// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file window.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Window interface
 */

#ifndef NV_INTERFACE_WINDOW_HH
#define NV_INTERFACE_WINDOW_HH

#include <nv/common.hh>
#include <nv/core/io_event.hh>
#include <nv/stl/string.hh>

namespace nv
{
	class context;
	class device;

	class window
	{
	public:
		virtual uint16 get_width() const = 0;
		virtual uint16 get_height() const = 0;
		virtual std::string get_title() const = 0;
		virtual void set_title( const std::string& title ) = 0;
		virtual context* get_context() = 0;
		virtual bool is_event_pending() = 0;
		// TODO: there should be a general options mechanism
		virtual void set_swap_control( bool ) = 0;
		virtual bool poll_event( io_event& event ) = 0;
		virtual void swap_buffers() = 0;
		virtual device* get_device() = 0;
		virtual ~window() {}
	};

} // namespace nv


#endif // NV_INTERFACE_WINDOW_HH
