// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LUA_DISPATCH_HH
#define NV_LUA_DISPATCH_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>
#include <nv/lua/lua_values.hh>
#include <nv/lua/lua_path.hh>

//struct lua_State;

namespace nv
{
	namespace lua
	{
		typedef int (__cdecl *lfunction) (struct lua_State *L);

		namespace detail
		{
			template <typename...>
			struct types {};

			template < typename R >
			struct call_and_push
			{
				template <typename... Args, typename... Vs>
				static void do_call(lua_State* L, R(*func)(Args...), Vs&&... vs)
				{
					push_value(L, func( nv::forward<Vs>(vs)...));
				}
				template <class C, typename... Args, typename... Vs>
				static void do_call(lua_State* L, C* c, R(C::*func)(Args...), Vs&&... vs)
				{
					push_value(L, (*c.*func)( nv::forward<Vs>(vs)...));
				}
				template <class C, typename... Args, typename... Vs>
				static void do_call( lua_State* L, C const * c, R( C::*func )( Args... ) const, Vs&&... vs )
				{
					push_value( L, ( *c.*func )( nv::forward<Vs>( vs )... ) );
				}
			};

			template <>
			struct call_and_push<void>
			{
				template <typename... Args, typename... Vs>
				static void do_call(lua_State*, void(*func)(Args...), Vs&&... vs)
				{
					func( nv::forward<Vs>(vs)...);
				}
				template <class C, typename... Args, typename... Vs>
				static void do_call(lua_State*, C* c, void(C::*func)(Args...), Vs&&... vs)
				{
					(*c.*func)( nv::forward<Vs>(vs)...);
				}
				template <class C, typename... Args, typename... Vs>
				static void do_call( lua_State*, C const * c, void( C::*func )( Args... ) const, Vs&&... vs )
				{
					( *c.*func )( nv::forward<Vs>( vs )... );
				}
			};

			template <typename R, typename... Args, typename Head, typename ...Tail, typename... Vs>
			int do_call(lua_State* L, int index, R(*func)(Args...), types<Head, Tail...>, Vs&&... vs)
			{
				do_call(L, index + 1, func, types < Tail... > {}, nv::forward<Vs>(vs)..., get_value<Head>(L, index)); return 1;
			}

			template <typename R, class C, typename... Args, typename Head, typename ...Tail, typename... Vs>
			int do_call(lua_State* L, int index, C* c, R(C::*func)(Args...), types<Head, Tail...>, Vs&&... vs)
			{
				do_call(L, index + 1, c, func, types < Tail... > {}, nv::forward<Vs>(vs)..., get_value<Head>(L, index)); return 1;
			}

			template <typename R, class C, typename... Args, typename Head, typename ...Tail, typename... Vs>
			int do_call( lua_State* L, int index, C const * c, R( C::*func )( Args... ) const, types<Head, Tail...>, Vs&&... vs )
			{
				do_call( L, index + 1, c, func, types < Tail... > {}, nv::forward<Vs>( vs )..., get_value<Head>( L, index ) ); return 1;
			}

			template <typename R, typename... Args, typename... Vs>
			int do_call(lua_State* L, int, R(*func)(Args...), types<>, Vs&&... vs)
			{
				call_and_push<R>::do_call(L, func, nv::forward<Vs>(vs)...);
				return 1;
			}

			template <typename R, class C, typename... Args, typename... Vs>
			int do_call(lua_State* L, int, C* c, R(C::*func)(Args...), types<>, Vs&&... vs)
			{
				call_and_push<R>::do_call(L, c, func, nv::forward<Vs>(vs)...);
				return 1;
			}

			template <typename R, class C, typename... Args, typename... Vs>
			int do_call( lua_State* L, int, C const * c, R( C::*func )( Args... ) const, types<>, Vs&&... vs )
			{
				call_and_push<R>::do_call( L, c, func, nv::forward<Vs>( vs )... );
				return 1;
			}

			template < typename R, typename... Args >
			int dispatch(lua_State* L, int index, R(*func)(Args...))
			{
				do_call(L, index, func, types < Args... > {});
				return 1;
			}
			template < typename R, class C, typename... Args >
			int dispatch(lua_State* L, int index, C* c, R( C::*func )( Args... ) )
			{
				do_call(L, index, c, func, types < Args... > {});
				return 1;
			}
			template < typename R, class C, typename... Args >
			int dispatch( lua_State* L, int index, C const * c, R( C::*func )( Args... ) const )
			{
				do_call( L, index, c, func, types < Args... > {} );
				return 1;
			}


			template < typename F, F f > 
			int function_wrapper( lua_State* L ) 
			{
				return dispatch(L, 1, f);
			}

			template < typename C, typename F, F f > 
			int object_method_wrapper( lua_State* L ) 
			{
				C* c = reinterpret_cast<C*>( to_ref_object( L, 1 ) );
				return dispatch( L, 2, c, f );
			}

			template < typename C, typename F, F f > 
			int fixed_method_wrapper( lua_State* L ) 
			{
				C* c = reinterpret_cast<C*>( to_pointer( L, nv::lua::detail::upvalue_index(1) ) );
				return dispatch( L, 1, c, f );
			}
			
		}

	}

}

#endif // NV_LUA_DISPATCH_HH
