typedef enum
{
    MIX_INIT_FLAC        = 0x00000001,
    MIX_INIT_MOD         = 0x00000002,
    MIX_INIT_MODPLUG     = 0x00000004,
    MIX_INIT_MP3         = 0x00000008,
    MIX_INIT_OGG         = 0x00000010,
    MIX_INIT_FLUIDSYNTH  = 0x00000020
} MIX_InitFlags;

#ifndef MIX_CHANNELS
#define MIX_CHANNELS    8
#endif

#define MIX_DEFAULT_FREQUENCY   22050
#if NV_ENDIANESS == NV_LITTLEENDIAN
#define MIX_DEFAULT_FORMAT  AUDIO_S16LSB
#else
#define MIX_DEFAULT_FORMAT  AUDIO_S16MSB
#endif
#define MIX_DEFAULT_CHANNELS    2
#define MIX_MAX_VOLUME          128

typedef struct Mix_Chunk {
    int allocated;
    Uint8 *abuf;
    Uint32 alen;
    Uint8 volume;
} Mix_Chunk;

typedef enum {
    MIX_NO_FADING,
    MIX_FADING_OUT,
    MIX_FADING_IN
} Mix_Fading;

typedef enum {
    MUS_NONE,
    MUS_CMD,
    MUS_WAV,
    MUS_MOD,
    MUS_MID,
    MUS_OGG,
    MUS_MP3,
    MUS_MP3_MAD,
    MUS_FLAC,
    MUS_MODPLUG
} Mix_MusicType;

typedef struct _Mix_Music Mix_Music;
typedef void (*Mix_EffectFunc_t)(int chan, void *stream, int len, void *udata);
typedef void (*Mix_EffectDone_t)(int chan, void *udata);

#define MIX_CHANNEL_POST  -2
#define MIX_EFFECTSMAXSPEED  "MIX_EFFECTSMAXSPEED"
#define Mix_SetError    SDL_SetError
#define Mix_GetError    SDL_GetError
#define Mix_LoadWAV(file)   Mix_LoadWAV_RW(SDL_RWFromFile(file, "rb"), 1)
#define Mix_PlayChannel(channel,chunk,loops) Mix_PlayChannelTimed(channel,chunk,loops,-1)
#define Mix_FadeInChannel(channel,chunk,loops,ms) Mix_FadeInChannelTimed(channel,chunk,loops,ms,-1)
