NV_FMOD_FUN( FMOD_RESULT, FMOD_Memory_Initialize          , (void *poolmem, int poollen, FMOD_MEMORY_ALLOCCALLBACK useralloc, FMOD_MEMORY_REALLOCCALLBACK userrealloc, FMOD_MEMORY_FREECALLBACK userfree, FMOD_MEMORY_TYPE memtypeflags) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Memory_GetStats            , (int *currentalloced, int *maxalloced, FMOD_BOOL blocking) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Debug_SetLevel             , (FMOD_DEBUGLEVEL level) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Debug_GetLevel             , (FMOD_DEBUGLEVEL *level) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_File_SetDiskBusy           , (int busy) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_File_GetDiskBusy           , (int *busy) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Create              , (FMOD_SYSTEM **system) ); 
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Release             , (FMOD_SYSTEM *system) ); 

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetOutput             , (FMOD_SYSTEM *system, FMOD_OUTPUTTYPE output) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetOutput             , (FMOD_SYSTEM *system, FMOD_OUTPUTTYPE *output) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetNumDrivers         , (FMOD_SYSTEM *system, int *numdrivers) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetDriverInfo         , (FMOD_SYSTEM *system, int id, char *name, int namelen, FMOD_GUID *guid) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetDriverInfoW        , (FMOD_SYSTEM *system, int id, short *name, int namelen, FMOD_GUID *guid) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetDriverCaps         , (FMOD_SYSTEM *system, int id, FMOD_CAPS *caps, int *controlpaneloutputrate, FMOD_SPEAKERMODE *controlpanelspeakermode) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetDriver             , (FMOD_SYSTEM *system, int driver) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetDriver             , (FMOD_SYSTEM *system, int *driver) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetHardwareChannels   , (FMOD_SYSTEM *system, int numhardwarechannels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetSoftwareChannels   , (FMOD_SYSTEM *system, int numsoftwarechannels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetSoftwareChannels   , (FMOD_SYSTEM *system, int *numsoftwarechannels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetSoftwareFormat     , (FMOD_SYSTEM *system, int samplerate, FMOD_SOUND_FORMAT format, int numoutputchannels, int maxinputchannels, FMOD_DSP_RESAMPLER resamplemethod) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetSoftwareFormat     , (FMOD_SYSTEM *system, int *samplerate, FMOD_SOUND_FORMAT *format, int *numoutputchannels, int *maxinputchannels, FMOD_DSP_RESAMPLER *resamplemethod, int *bits) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetDSPBufferSize      , (FMOD_SYSTEM *system, unsigned int bufferlength, int numbuffers) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetDSPBufferSize      , (FMOD_SYSTEM *system, unsigned int *bufferlength, int *numbuffers) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetFileSystem         , (FMOD_SYSTEM *system, FMOD_FILE_OPENCALLBACK useropen, FMOD_FILE_CLOSECALLBACK userclose, FMOD_FILE_READCALLBACK userread, FMOD_FILE_SEEKCALLBACK userseek, FMOD_FILE_ASYNCREADCALLBACK userasyncread, FMOD_FILE_ASYNCCANCELCALLBACK userasynccancel, int blockalign) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_AttachFileSystem      , (FMOD_SYSTEM *system, FMOD_FILE_OPENCALLBACK useropen, FMOD_FILE_CLOSECALLBACK userclose, FMOD_FILE_READCALLBACK userread, FMOD_FILE_SEEKCALLBACK userseek) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetAdvancedSettings   , (FMOD_SYSTEM *system, FMOD_ADVANCEDSETTINGS *settings) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetAdvancedSettings   , (FMOD_SYSTEM *system, FMOD_ADVANCEDSETTINGS *settings) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetSpeakerMode        , (FMOD_SYSTEM *system, FMOD_SPEAKERMODE speakermode) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetSpeakerMode        , (FMOD_SYSTEM *system, FMOD_SPEAKERMODE *speakermode) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetCallback           , (FMOD_SYSTEM *system, FMOD_SYSTEM_CALLBACK callback) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetPluginPath         , (FMOD_SYSTEM *system, const char *path) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_LoadPlugin            , (FMOD_SYSTEM *system, const char *filename, unsigned int *handle, unsigned int priority) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_UnloadPlugin          , (FMOD_SYSTEM *system, unsigned int handle) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetNumPlugins         , (FMOD_SYSTEM *system, FMOD_PLUGINTYPE plugintype, int *numplugins) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetPluginHandle       , (FMOD_SYSTEM *system, FMOD_PLUGINTYPE plugintype, int index, unsigned int *handle) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetPluginInfo         , (FMOD_SYSTEM *system, unsigned int handle, FMOD_PLUGINTYPE *plugintype, char *name, int namelen, unsigned int *version) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetOutputByPlugin     , (FMOD_SYSTEM *system, unsigned int handle) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetOutputByPlugin     , (FMOD_SYSTEM *system, unsigned int *handle) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateDSPByPlugin     , (FMOD_SYSTEM *system, unsigned int handle, FMOD_DSP **dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_RegisterCodec         , (FMOD_SYSTEM *system, FMOD_CODEC_DESCRIPTION *description, unsigned int *handle, unsigned int priority) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_RegisterDSP           , (FMOD_SYSTEM *system, FMOD_DSP_DESCRIPTION *description, unsigned int *handle) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Init                  , (FMOD_SYSTEM *system, int maxchannels, FMOD_INITFLAGS flags, void *extradriverdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Close                 , (FMOD_SYSTEM *system) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Update                , (FMOD_SYSTEM *system) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Set3DSettings         , (FMOD_SYSTEM *system, float dopplerscale, float distancefactor, float rolloffscale) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Get3DSettings         , (FMOD_SYSTEM *system, float *dopplerscale, float *distancefactor, float *rolloffscale) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Set3DNumListeners     , (FMOD_SYSTEM *system, int numlisteners) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Get3DNumListeners     , (FMOD_SYSTEM *system, int *numlisteners) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Set3DListenerAttributes, (FMOD_SYSTEM *system, int listener, const FMOD_VECTOR *pos, const FMOD_VECTOR *vel, const FMOD_VECTOR *forward, const FMOD_VECTOR *up) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Get3DListenerAttributes, (FMOD_SYSTEM *system, int listener, FMOD_VECTOR *pos, FMOD_VECTOR *vel, FMOD_VECTOR *forward, FMOD_VECTOR *up) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Set3DRolloffCallback  , (FMOD_SYSTEM *system, FMOD_3D_ROLLOFFCALLBACK callback) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Set3DSpeakerPosition  , (FMOD_SYSTEM *system, FMOD_SPEAKER speaker, float x, float y, FMOD_BOOL active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_Get3DSpeakerPosition  , (FMOD_SYSTEM *system, FMOD_SPEAKER speaker, float *x, float *y, FMOD_BOOL *active) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetStreamBufferSize   , (FMOD_SYSTEM *system, unsigned int filebuffersize, FMOD_TIMEUNIT filebuffersizetype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetStreamBufferSize   , (FMOD_SYSTEM *system, unsigned int *filebuffersize, FMOD_TIMEUNIT *filebuffersizetype) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetVersion            , (FMOD_SYSTEM *system, unsigned int *version) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetOutputHandle       , (FMOD_SYSTEM *system, void **handle) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetChannelsPlaying    , (FMOD_SYSTEM *system, int *channels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetHardwareChannels   , (FMOD_SYSTEM *system, int *numhardwarechannels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetCPUUsage           , (FMOD_SYSTEM *system, float *dsp, float *stream, float *geometry, float *update, float *total) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetSoundRAM           , (FMOD_SYSTEM *system, int *currentalloced, int *maxalloced, int *total) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetNumCDROMDrives     , (FMOD_SYSTEM *system, int *numdrives) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetCDROMDriveName     , (FMOD_SYSTEM *system, int drive, char *drivename, int drivenamelen, char *scsiname, int scsinamelen, char *devicename, int devicenamelen) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetSpectrum           , (FMOD_SYSTEM *system, float *spectrumarray, int numvalues, int channeloffset, FMOD_DSP_FFT_WINDOW windowtype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetWaveData           , (FMOD_SYSTEM *system, float *wavearray, int numvalues, int channeloffset) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateSound           , (FMOD_SYSTEM *system, const char *name_or_data, FMOD_MODE mode, FMOD_CREATESOUNDEXINFO *exinfo, FMOD_SOUND **sound) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateStream          , (FMOD_SYSTEM *system, const char *name_or_data, FMOD_MODE mode, FMOD_CREATESOUNDEXINFO *exinfo, FMOD_SOUND **sound) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateDSP             , (FMOD_SYSTEM *system, FMOD_DSP_DESCRIPTION *description, FMOD_DSP **dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateDSPByType       , (FMOD_SYSTEM *system, FMOD_DSP_TYPE type, FMOD_DSP **dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateChannelGroup    , (FMOD_SYSTEM *system, const char *name, FMOD_CHANNELGROUP **channelgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateSoundGroup      , (FMOD_SYSTEM *system, const char *name, FMOD_SOUNDGROUP **soundgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateReverb          , (FMOD_SYSTEM *system, FMOD_REVERB **reverb) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_PlaySound             , (FMOD_SYSTEM *system, FMOD_CHANNELINDEX channelid, FMOD_SOUND *sound, FMOD_BOOL paused, FMOD_CHANNEL **channel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_PlayDSP               , (FMOD_SYSTEM *system, FMOD_CHANNELINDEX channelid, FMOD_DSP *dsp, FMOD_BOOL paused, FMOD_CHANNEL **channel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetChannel            , (FMOD_SYSTEM *system, int channelid, FMOD_CHANNEL **channel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetMasterChannelGroup , (FMOD_SYSTEM *system, FMOD_CHANNELGROUP **channelgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetMasterSoundGroup   , (FMOD_SYSTEM *system, FMOD_SOUNDGROUP **soundgroup) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetReverbProperties   , (FMOD_SYSTEM *system, const FMOD_REVERB_PROPERTIES *prop) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetReverbProperties   , (FMOD_SYSTEM *system, FMOD_REVERB_PROPERTIES *prop) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetReverbAmbientProperties, (FMOD_SYSTEM *system, FMOD_REVERB_PROPERTIES *prop) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetReverbAmbientProperties, (FMOD_SYSTEM *system, FMOD_REVERB_PROPERTIES *prop) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetDSPHead            , (FMOD_SYSTEM *system, FMOD_DSP **dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_AddDSP                , (FMOD_SYSTEM *system, FMOD_DSP *dsp, FMOD_DSPCONNECTION **connection) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_LockDSP               , (FMOD_SYSTEM *system) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_UnlockDSP             , (FMOD_SYSTEM *system) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetDSPClock           , (FMOD_SYSTEM *system, unsigned int *hi, unsigned int *lo) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetRecordNumDrivers   , (FMOD_SYSTEM *system, int *numdrivers) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetRecordDriverInfo   , (FMOD_SYSTEM *system, int id, char *name, int namelen, FMOD_GUID *guid) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetRecordDriverInfoW  , (FMOD_SYSTEM *system, int id, short *name, int namelen, FMOD_GUID *guid) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetRecordDriverCaps   , (FMOD_SYSTEM *system, int id, FMOD_CAPS *caps, int *minfrequency, int *maxfrequency) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetRecordPosition     , (FMOD_SYSTEM *system, int id, unsigned int *position) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_RecordStart           , (FMOD_SYSTEM *system, int id, FMOD_SOUND *sound, FMOD_BOOL loop) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_RecordStop            , (FMOD_SYSTEM *system, int id) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_IsRecording           , (FMOD_SYSTEM *system, int id, FMOD_BOOL *recording) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_CreateGeometry        , (FMOD_SYSTEM *system, int maxpolygons, int maxvertices, FMOD_GEOMETRY **geometry) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetGeometrySettings   , (FMOD_SYSTEM *system, float maxworldsize) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetGeometrySettings   , (FMOD_SYSTEM *system, float *maxworldsize) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_LoadGeometry          , (FMOD_SYSTEM *system, const void *data, int datasize, FMOD_GEOMETRY **geometry) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetGeometryOcclusion  , (FMOD_SYSTEM *system, const FMOD_VECTOR *listener, const FMOD_VECTOR *source, float *direct, float *reverb) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetNetworkProxy       , (FMOD_SYSTEM *system, const char *proxy) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetNetworkProxy       , (FMOD_SYSTEM *system, char *proxy, int proxylen) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetNetworkTimeout     , (FMOD_SYSTEM *system, int timeout) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetNetworkTimeout     , (FMOD_SYSTEM *system, int *timeout) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_SetUserData           , (FMOD_SYSTEM *system, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetUserData           , (FMOD_SYSTEM *system, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_System_GetMemoryInfo         , (FMOD_SYSTEM *system, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Release                , (FMOD_SOUND *sound) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetSystemObject        , (FMOD_SOUND *sound, FMOD_SYSTEM **system) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Lock                   , (FMOD_SOUND *sound, unsigned int offset, unsigned int length, void **ptr1, void **ptr2, unsigned int *len1, unsigned int *len2) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Unlock                 , (FMOD_SOUND *sound, void *ptr1, void *ptr2, unsigned int len1, unsigned int len2) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetDefaults            , (FMOD_SOUND *sound, float frequency, float volume, float pan, int priority) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetDefaults            , (FMOD_SOUND *sound, float *frequency, float *volume, float *pan, int *priority) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetVariations          , (FMOD_SOUND *sound, float frequencyvar, float volumevar, float panvar) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetVariations          , (FMOD_SOUND *sound, float *frequencyvar, float *volumevar, float *panvar) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Set3DMinMaxDistance    , (FMOD_SOUND *sound, float min, float max) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Get3DMinMaxDistance    , (FMOD_SOUND *sound, float *min, float *max) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Set3DConeSettings      , (FMOD_SOUND *sound, float insideconeangle, float outsideconeangle, float outsidevolume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Get3DConeSettings      , (FMOD_SOUND *sound, float *insideconeangle, float *outsideconeangle, float *outsidevolume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Set3DCustomRolloff     , (FMOD_SOUND *sound, FMOD_VECTOR *points, int numpoints) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_Get3DCustomRolloff     , (FMOD_SOUND *sound, FMOD_VECTOR **points, int *numpoints) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetSubSound            , (FMOD_SOUND *sound, int index, FMOD_SOUND *subsound) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetSubSound            , (FMOD_SOUND *sound, int index, FMOD_SOUND **subsound) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetSubSoundSentence    , (FMOD_SOUND *sound, int *subsoundlist, int numsubsounds) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetName                , (FMOD_SOUND *sound, char *name, int namelen) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetLength              , (FMOD_SOUND *sound, unsigned int *length, FMOD_TIMEUNIT lengthtype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetFormat              , (FMOD_SOUND *sound, FMOD_SOUND_TYPE *type, FMOD_SOUND_FORMAT *format, int *channels, int *bits) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetNumSubSounds        , (FMOD_SOUND *sound, int *numsubsounds) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetNumTags             , (FMOD_SOUND *sound, int *numtags, int *numtagsupdated) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetTag                 , (FMOD_SOUND *sound, const char *name, int index, FMOD_TAG *tag) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetOpenState           , (FMOD_SOUND *sound, FMOD_OPENSTATE *openstate, unsigned int *percentbuffered, FMOD_BOOL *starving, FMOD_BOOL *diskbusy) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_ReadData               , (FMOD_SOUND *sound, void *buffer, unsigned int lenbytes, unsigned int *read) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SeekData               , (FMOD_SOUND *sound, unsigned int pcm) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetSoundGroup          , (FMOD_SOUND *sound, FMOD_SOUNDGROUP *soundgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetSoundGroup          , (FMOD_SOUND *sound, FMOD_SOUNDGROUP **soundgroup) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetNumSyncPoints       , (FMOD_SOUND *sound, int *numsyncpoints) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetSyncPoint           , (FMOD_SOUND *sound, int index, FMOD_SYNCPOINT **point) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetSyncPointInfo       , (FMOD_SOUND *sound, FMOD_SYNCPOINT *point, char *name, int namelen, unsigned int *offset, FMOD_TIMEUNIT offsettype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_AddSyncPoint           , (FMOD_SOUND *sound, unsigned int offset, FMOD_TIMEUNIT offsettype, const char *name, FMOD_SYNCPOINT **point) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_DeleteSyncPoint        , (FMOD_SOUND *sound, FMOD_SYNCPOINT *point) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetMode                , (FMOD_SOUND *sound, FMOD_MODE mode) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetMode                , (FMOD_SOUND *sound, FMOD_MODE *mode) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetLoopCount           , (FMOD_SOUND *sound, int loopcount) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetLoopCount           , (FMOD_SOUND *sound, int *loopcount) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetLoopPoints          , (FMOD_SOUND *sound, unsigned int loopstart, FMOD_TIMEUNIT loopstarttype, unsigned int loopend, FMOD_TIMEUNIT loopendtype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetLoopPoints          , (FMOD_SOUND *sound, unsigned int *loopstart, FMOD_TIMEUNIT loopstarttype, unsigned int *loopend, FMOD_TIMEUNIT loopendtype) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetMusicNumChannels    , (FMOD_SOUND *sound, int *numchannels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetMusicChannelVolume  , (FMOD_SOUND *sound, int channel, float volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetMusicChannelVolume  , (FMOD_SOUND *sound, int channel, float *volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetMusicSpeed          , (FMOD_SOUND *sound, float speed) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetMusicSpeed          , (FMOD_SOUND *sound, float *speed) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_SetUserData            , (FMOD_SOUND *sound, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetUserData            , (FMOD_SOUND *sound, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Sound_GetMemoryInfo          , (FMOD_SOUND *sound, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetSystemObject      , (FMOD_CHANNEL *channel, FMOD_SYSTEM **system) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Stop                 , (FMOD_CHANNEL *channel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetPaused            , (FMOD_CHANNEL *channel, FMOD_BOOL paused) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetPaused            , (FMOD_CHANNEL *channel, FMOD_BOOL *paused) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetVolume            , (FMOD_CHANNEL *channel, float volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetVolume            , (FMOD_CHANNEL *channel, float *volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetFrequency         , (FMOD_CHANNEL *channel, float frequency) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetFrequency         , (FMOD_CHANNEL *channel, float *frequency) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetPan               , (FMOD_CHANNEL *channel, float pan) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetPan               , (FMOD_CHANNEL *channel, float *pan) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetDelay             , (FMOD_CHANNEL *channel, FMOD_DELAYTYPE delaytype, unsigned int delayhi, unsigned int delaylo) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetDelay             , (FMOD_CHANNEL *channel, FMOD_DELAYTYPE delaytype, unsigned int *delayhi, unsigned int *delaylo) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetSpeakerMix        , (FMOD_CHANNEL *channel, float frontleft, float frontright, float center, float lfe, float backleft, float backright, float sideleft, float sideright) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetSpeakerMix        , (FMOD_CHANNEL *channel, float *frontleft, float *frontright, float *center, float *lfe, float *backleft, float *backright, float *sideleft, float *sideright) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetSpeakerLevels     , (FMOD_CHANNEL *channel, FMOD_SPEAKER speaker, float *levels, int numlevels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetSpeakerLevels     , (FMOD_CHANNEL *channel, FMOD_SPEAKER speaker, float *levels, int numlevels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetInputChannelMix   , (FMOD_CHANNEL *channel, float *levels, int numlevels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetInputChannelMix   , (FMOD_CHANNEL *channel, float *levels, int numlevels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetMute              , (FMOD_CHANNEL *channel, FMOD_BOOL mute) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetMute              , (FMOD_CHANNEL *channel, FMOD_BOOL *mute) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetPriority          , (FMOD_CHANNEL *channel, int priority) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetPriority          , (FMOD_CHANNEL *channel, int *priority) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetPosition          , (FMOD_CHANNEL *channel, unsigned int position, FMOD_TIMEUNIT postype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetPosition          , (FMOD_CHANNEL *channel, unsigned int *position, FMOD_TIMEUNIT postype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetReverbProperties  , (FMOD_CHANNEL *channel, const FMOD_REVERB_CHANNELPROPERTIES *prop) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetReverbProperties  , (FMOD_CHANNEL *channel, FMOD_REVERB_CHANNELPROPERTIES *prop) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetLowPassGain       , (FMOD_CHANNEL *channel, float gain) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetLowPassGain       , (FMOD_CHANNEL *channel, float *gain) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetChannelGroup      , (FMOD_CHANNEL *channel, FMOD_CHANNELGROUP *channelgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetChannelGroup      , (FMOD_CHANNEL *channel, FMOD_CHANNELGROUP **channelgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetCallback          , (FMOD_CHANNEL *channel, FMOD_CHANNEL_CALLBACK callback) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DAttributes      , (FMOD_CHANNEL *channel, const FMOD_VECTOR *pos, const FMOD_VECTOR *vel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DAttributes      , (FMOD_CHANNEL *channel, FMOD_VECTOR *pos, FMOD_VECTOR *vel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DMinMaxDistance  , (FMOD_CHANNEL *channel, float mindistance, float maxdistance) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DMinMaxDistance  , (FMOD_CHANNEL *channel, float *mindistance, float *maxdistance) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DConeSettings    , (FMOD_CHANNEL *channel, float insideconeangle, float outsideconeangle, float outsidevolume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DConeSettings    , (FMOD_CHANNEL *channel, float *insideconeangle, float *outsideconeangle, float *outsidevolume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DConeOrientation , (FMOD_CHANNEL *channel, FMOD_VECTOR *orientation) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DConeOrientation , (FMOD_CHANNEL *channel, FMOD_VECTOR *orientation) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DCustomRolloff   , (FMOD_CHANNEL *channel, FMOD_VECTOR *points, int numpoints) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DCustomRolloff   , (FMOD_CHANNEL *channel, FMOD_VECTOR **points, int *numpoints) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DOcclusion       , (FMOD_CHANNEL *channel, float directocclusion, float reverbocclusion) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DOcclusion       , (FMOD_CHANNEL *channel, float *directocclusion, float *reverbocclusion) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DSpread          , (FMOD_CHANNEL *channel, float angle) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DSpread          , (FMOD_CHANNEL *channel, float *angle) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DPanLevel        , (FMOD_CHANNEL *channel, float level) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DPanLevel        , (FMOD_CHANNEL *channel, float *level) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DDopplerLevel    , (FMOD_CHANNEL *channel, float level) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DDopplerLevel    , (FMOD_CHANNEL *channel, float *level) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Set3DDistanceFilter  , (FMOD_CHANNEL *channel, FMOD_BOOL custom, float customLevel, float centerFreq) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_Get3DDistanceFilter  , (FMOD_CHANNEL *channel, FMOD_BOOL *custom, float *customLevel, float *centerFreq) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetDSPHead           , (FMOD_CHANNEL *channel, FMOD_DSP **dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_AddDSP               , (FMOD_CHANNEL *channel, FMOD_DSP *dsp, FMOD_DSPCONNECTION **connection) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_IsPlaying            , (FMOD_CHANNEL *channel, FMOD_BOOL *isplaying) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_IsVirtual            , (FMOD_CHANNEL *channel, FMOD_BOOL *isvirtual) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetAudibility        , (FMOD_CHANNEL *channel, float *audibility) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetCurrentSound      , (FMOD_CHANNEL *channel, FMOD_SOUND **sound) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetSpectrum          , (FMOD_CHANNEL *channel, float *spectrumarray, int numvalues, int channeloffset, FMOD_DSP_FFT_WINDOW windowtype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetWaveData          , (FMOD_CHANNEL *channel, float *wavearray, int numvalues, int channeloffset) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetIndex             , (FMOD_CHANNEL *channel, int *index) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetMode              , (FMOD_CHANNEL *channel, FMOD_MODE mode) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetMode              , (FMOD_CHANNEL *channel, FMOD_MODE *mode) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetLoopCount         , (FMOD_CHANNEL *channel, int loopcount) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetLoopCount         , (FMOD_CHANNEL *channel, int *loopcount) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetLoopPoints        , (FMOD_CHANNEL *channel, unsigned int loopstart, FMOD_TIMEUNIT loopstarttype, unsigned int loopend, FMOD_TIMEUNIT loopendtype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetLoopPoints        , (FMOD_CHANNEL *channel, unsigned int *loopstart, FMOD_TIMEUNIT loopstarttype, unsigned int *loopend, FMOD_TIMEUNIT loopendtype) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_SetUserData          , (FMOD_CHANNEL *channel, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetUserData          , (FMOD_CHANNEL *channel, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Channel_GetMemoryInfo        , (FMOD_CHANNEL *channel, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_Release         , (FMOD_CHANNELGROUP *channelgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetSystemObject , (FMOD_CHANNELGROUP *channelgroup, FMOD_SYSTEM **system) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_SetVolume       , (FMOD_CHANNELGROUP *channelgroup, float volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetVolume       , (FMOD_CHANNELGROUP *channelgroup, float *volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_SetPitch        , (FMOD_CHANNELGROUP *channelgroup, float pitch) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetPitch        , (FMOD_CHANNELGROUP *channelgroup, float *pitch) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_Set3DOcclusion  , (FMOD_CHANNELGROUP *channelgroup, float directocclusion, float reverbocclusion) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_Get3DOcclusion  , (FMOD_CHANNELGROUP *channelgroup, float *directocclusion, float *reverbocclusion) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_SetPaused       , (FMOD_CHANNELGROUP *channelgroup, FMOD_BOOL paused) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetPaused       , (FMOD_CHANNELGROUP *channelgroup, FMOD_BOOL *paused) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_SetMute         , (FMOD_CHANNELGROUP *channelgroup, FMOD_BOOL mute) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetMute         , (FMOD_CHANNELGROUP *channelgroup, FMOD_BOOL *mute) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_Stop            , (FMOD_CHANNELGROUP *channelgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_OverrideVolume  , (FMOD_CHANNELGROUP *channelgroup, float volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_OverrideFrequency, (FMOD_CHANNELGROUP *channelgroup, float frequency) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_OverridePan     , (FMOD_CHANNELGROUP *channelgroup, float pan) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_OverrideReverbProperties, (FMOD_CHANNELGROUP *channelgroup, const FMOD_REVERB_CHANNELPROPERTIES *prop) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_Override3DAttributes, (FMOD_CHANNELGROUP *channelgroup, const FMOD_VECTOR *pos, const FMOD_VECTOR *vel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_OverrideSpeakerMix, (FMOD_CHANNELGROUP *channelgroup, float frontleft, float frontright, float center, float lfe, float backleft, float backright, float sideleft, float sideright) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_AddGroup        , (FMOD_CHANNELGROUP *channelgroup, FMOD_CHANNELGROUP *group) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetNumGroups    , (FMOD_CHANNELGROUP *channelgroup, int *numgroups) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetGroup        , (FMOD_CHANNELGROUP *channelgroup, int index, FMOD_CHANNELGROUP **group) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetParentGroup  , (FMOD_CHANNELGROUP *channelgroup, FMOD_CHANNELGROUP **group) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetDSPHead      , (FMOD_CHANNELGROUP *channelgroup, FMOD_DSP **dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_AddDSP          , (FMOD_CHANNELGROUP *channelgroup, FMOD_DSP *dsp, FMOD_DSPCONNECTION **connection) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetName         , (FMOD_CHANNELGROUP *channelgroup, char *name, int namelen) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetNumChannels  , (FMOD_CHANNELGROUP *channelgroup, int *numchannels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetChannel      , (FMOD_CHANNELGROUP *channelgroup, int index, FMOD_CHANNEL **channel) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetSpectrum     , (FMOD_CHANNELGROUP *channelgroup, float *spectrumarray, int numvalues, int channeloffset, FMOD_DSP_FFT_WINDOW windowtype) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetWaveData     , (FMOD_CHANNELGROUP *channelgroup, float *wavearray, int numvalues, int channeloffset) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_SetUserData     , (FMOD_CHANNELGROUP *channelgroup, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetUserData     , (FMOD_CHANNELGROUP *channelgroup, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_ChannelGroup_GetMemoryInfo   , (FMOD_CHANNELGROUP *channelgroup, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_Release           , (FMOD_SOUNDGROUP *soundgroup) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetSystemObject   , (FMOD_SOUNDGROUP *soundgroup, FMOD_SYSTEM **system) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_SetMaxAudible     , (FMOD_SOUNDGROUP *soundgroup, int maxaudible) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetMaxAudible     , (FMOD_SOUNDGROUP *soundgroup, int *maxaudible) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_SetMaxAudibleBehavior, (FMOD_SOUNDGROUP *soundgroup, FMOD_SOUNDGROUP_BEHAVIOR behavior) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetMaxAudibleBehavior, (FMOD_SOUNDGROUP *soundgroup, FMOD_SOUNDGROUP_BEHAVIOR *behavior) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_SetMuteFadeSpeed  , (FMOD_SOUNDGROUP *soundgroup, float speed) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetMuteFadeSpeed  , (FMOD_SOUNDGROUP *soundgroup, float *speed) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_SetVolume         , (FMOD_SOUNDGROUP *soundgroup, float volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetVolume         , (FMOD_SOUNDGROUP *soundgroup, float *volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_Stop              , (FMOD_SOUNDGROUP *soundgroup) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetName           , (FMOD_SOUNDGROUP *soundgroup, char *name, int namelen) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetNumSounds      , (FMOD_SOUNDGROUP *soundgroup, int *numsounds) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetSound          , (FMOD_SOUNDGROUP *soundgroup, int index, FMOD_SOUND **sound) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetNumPlaying     , (FMOD_SOUNDGROUP *soundgroup, int *numplaying) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_SetUserData       , (FMOD_SOUNDGROUP *soundgroup, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetUserData       , (FMOD_SOUNDGROUP *soundgroup, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_SoundGroup_GetMemoryInfo     , (FMOD_SOUNDGROUP *soundgroup, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_Release                  , (FMOD_DSP *dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetSystemObject          , (FMOD_DSP *dsp, FMOD_SYSTEM **system) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_AddInput                 , (FMOD_DSP *dsp, FMOD_DSP *target, FMOD_DSPCONNECTION **connection) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_DisconnectFrom           , (FMOD_DSP *dsp, FMOD_DSP *target) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_DisconnectAll            , (FMOD_DSP *dsp, FMOD_BOOL inputs, FMOD_BOOL outputs) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_Remove                   , (FMOD_DSP *dsp) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetNumInputs             , (FMOD_DSP *dsp, int *numinputs) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetNumOutputs            , (FMOD_DSP *dsp, int *numoutputs) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetInput                 , (FMOD_DSP *dsp, int index, FMOD_DSP **input, FMOD_DSPCONNECTION **inputconnection) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetOutput                , (FMOD_DSP *dsp, int index, FMOD_DSP **output, FMOD_DSPCONNECTION **outputconnection) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_SetActive                , (FMOD_DSP *dsp, FMOD_BOOL active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetActive                , (FMOD_DSP *dsp, FMOD_BOOL *active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_SetBypass                , (FMOD_DSP *dsp, FMOD_BOOL bypass) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetBypass                , (FMOD_DSP *dsp, FMOD_BOOL *bypass) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_SetSpeakerActive         , (FMOD_DSP *dsp, FMOD_SPEAKER speaker, FMOD_BOOL active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetSpeakerActive         , (FMOD_DSP *dsp, FMOD_SPEAKER speaker, FMOD_BOOL *active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_Reset                    , (FMOD_DSP *dsp) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_SetParameter             , (FMOD_DSP *dsp, int index, float value) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetParameter             , (FMOD_DSP *dsp, int index, float *value, char *valuestr, int valuestrlen) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetNumParameters         , (FMOD_DSP *dsp, int *numparams) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetParameterInfo         , (FMOD_DSP *dsp, int index, char *name, char *label, char *description, int descriptionlen, float *min, float *max) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_ShowConfigDialog         , (FMOD_DSP *dsp, void *hwnd, FMOD_BOOL show) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetInfo                  , (FMOD_DSP *dsp, char *name, unsigned int *version, int *channels, int *configwidth, int *configheight) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetType                  , (FMOD_DSP *dsp, FMOD_DSP_TYPE *type) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_SetDefaults              , (FMOD_DSP *dsp, float frequency, float volume, float pan, int priority) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetDefaults              , (FMOD_DSP *dsp, float *frequency, float *volume, float *pan, int *priority) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_SetUserData              , (FMOD_DSP *dsp, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetUserData              , (FMOD_DSP *dsp, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSP_GetMemoryInfo            , (FMOD_DSP *dsp, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_GetInput       , (FMOD_DSPCONNECTION *dspconnection, FMOD_DSP **input) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_GetOutput      , (FMOD_DSPCONNECTION *dspconnection, FMOD_DSP **output) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_SetMix         , (FMOD_DSPCONNECTION *dspconnection, float volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_GetMix         , (FMOD_DSPCONNECTION *dspconnection, float *volume) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_SetLevels      , (FMOD_DSPCONNECTION *dspconnection, FMOD_SPEAKER speaker, float *levels, int numlevels) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_GetLevels      , (FMOD_DSPCONNECTION *dspconnection, FMOD_SPEAKER speaker, float *levels, int numlevels) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_SetUserData    , (FMOD_DSPCONNECTION *dspconnection, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_GetUserData    , (FMOD_DSPCONNECTION *dspconnection, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_DSPConnection_GetMemoryInfo  , (FMOD_DSPCONNECTION *dspconnection, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_Release             , (FMOD_GEOMETRY *geometry) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_AddPolygon          , (FMOD_GEOMETRY *geometry, float directocclusion, float reverbocclusion, FMOD_BOOL doublesided, int numvertices, const FMOD_VECTOR *vertices, int *polygonindex) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetNumPolygons      , (FMOD_GEOMETRY *geometry, int *numpolygons) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetMaxPolygons      , (FMOD_GEOMETRY *geometry, int *maxpolygons, int *maxvertices) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetPolygonNumVertices, (FMOD_GEOMETRY *geometry, int index, int *numvertices) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_SetPolygonVertex    , (FMOD_GEOMETRY *geometry, int index, int vertexindex, const FMOD_VECTOR *vertex) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetPolygonVertex    , (FMOD_GEOMETRY *geometry, int index, int vertexindex, FMOD_VECTOR *vertex) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_SetPolygonAttributes, (FMOD_GEOMETRY *geometry, int index, float directocclusion, float reverbocclusion, FMOD_BOOL doublesided) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetPolygonAttributes, (FMOD_GEOMETRY *geometry, int index, float *directocclusion, float *reverbocclusion, FMOD_BOOL *doublesided) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_SetActive           , (FMOD_GEOMETRY *geometry, FMOD_BOOL active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetActive           , (FMOD_GEOMETRY *geometry, FMOD_BOOL *active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_SetRotation         , (FMOD_GEOMETRY *geometry, const FMOD_VECTOR *forward, const FMOD_VECTOR *up) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetRotation         , (FMOD_GEOMETRY *geometry, FMOD_VECTOR *forward, FMOD_VECTOR *up) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_SetPosition         , (FMOD_GEOMETRY *geometry, const FMOD_VECTOR *position) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetPosition         , (FMOD_GEOMETRY *geometry, FMOD_VECTOR *position) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_SetScale            , (FMOD_GEOMETRY *geometry, const FMOD_VECTOR *scale) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetScale            , (FMOD_GEOMETRY *geometry, FMOD_VECTOR *scale) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_Save                , (FMOD_GEOMETRY *geometry, void *data, int *datasize) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_SetUserData         , (FMOD_GEOMETRY *geometry, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetUserData         , (FMOD_GEOMETRY *geometry, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Geometry_GetMemoryInfo       , (FMOD_GEOMETRY *geometry, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_Release               , (FMOD_REVERB *reverb) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_Set3DAttributes       , (FMOD_REVERB *reverb, const FMOD_VECTOR *position, float mindistance, float maxdistance) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_Get3DAttributes       , (FMOD_REVERB *reverb, FMOD_VECTOR *position, float *mindistance, float *maxdistance) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_SetProperties         , (FMOD_REVERB *reverb, const FMOD_REVERB_PROPERTIES *properties) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_GetProperties         , (FMOD_REVERB *reverb, FMOD_REVERB_PROPERTIES *properties) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_SetActive             , (FMOD_REVERB *reverb, FMOD_BOOL active) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_GetActive             , (FMOD_REVERB *reverb, FMOD_BOOL *active) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_SetUserData           , (FMOD_REVERB *reverb, void *userdata) );
NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_GetUserData           , (FMOD_REVERB *reverb, void **userdata) );

NV_FMOD_FUN( FMOD_RESULT, FMOD_Reverb_GetMemoryInfo         , (FMOD_REVERB *reverb, unsigned int memorybits, unsigned int event_memorybits, unsigned int *memoryused, FMOD_MEMORY_USAGE_DETAILS *memoryused_details) );
