#define ASSIMP_CFLAGS_SHARED  0x1 
#define ASSIMP_CFLAGS_STLPORT 0x2
#define ASSIMP_CFLAGS_DEBUG   0x4
#define ASSIMP_CFLAGS_NOBOOST           0x8
#define ASSIMP_CFLAGS_SINGLETHREADED    0x10

#define AI_MATH_PI			(3.141592653589793238462643383279 )
#define AI_MATH_TWO_PI		(AI_MATH_PI * 2.0)
#define AI_MATH_HALF_PI		(AI_MATH_PI * 0.5)

#define AI_MATH_PI_F		(3.1415926538f)
#define AI_MATH_TWO_PI_F	(AI_MATH_PI_F * 2.0f)
#define AI_MATH_HALF_PI_F	(AI_MATH_PI_F * 0.5f)

#define AI_DEG_TO_RAD(x) (x*0.0174532925f)
#define AI_RAD_TO_DEG(x) (x*57.2957795f)

typedef void (*aiLogStreamCallback)(const char* /* message */, char* /* user */);

struct aiLogStream
{
	aiLogStreamCallback callback;
	char* user;
};

struct aiPropertyStore { char sentinel; };

typedef int aiBool;

#define AI_FALSE 0
#define AI_TRUE 1

struct aiVector3D
{
	float x,y,z;
};

struct aiVector2D
{
	float x,y;
};

struct aiColor4D
{
	float r, g, b, a;
};

struct aiMatrix3x3
{
	float a1, a2, a3;
	float b1, b2, b3;
	float c1, c2, c3;
};

struct aiMatrix4x4
{
	float a1, a2, a3, a4;
	float b1, b2, b3, b4;
	float c1, c2, c3, c4;
	float d1, d2, d3, d4;
};

struct aiQuaternion
{
	float w, x, y, z;	
};

struct aiPlane
{
	float a,b,c,d;
};

struct aiRay
{
	aiVector3D pos, dir;
};

struct aiColor3D
{
	float r, g, b;
};

#	define MAXLEN 1024

struct aiString
{
	size_t length;
	char data[MAXLEN];
};

enum aiReturn
{
	aiReturn_SUCCESS = 0x0,
	aiReturn_FAILURE = -0x1,
	aiReturn_OUTOFMEMORY = -0x3,
	_AI_ENFORCE_ENUM_SIZE = 0x7fffffff 
};  

enum aiOrigin
{
	aiOrigin_SET = 0x0,	
	aiOrigin_CUR = 0x1,		
	aiOrigin_END = 0x2,
	_AI_ORIGIN_ENFORCE_ENUM_SIZE = 0x7fffffff 
}; 

enum aiDefaultLogStream	
{
	aiDefaultLogStream_FILE = 0x1,
	aiDefaultLogStream_STDOUT = 0x2,
	aiDefaultLogStream_STDERR = 0x4,
	aiDefaultLogStream_DEBUGGER = 0x8,
	_AI_DLS_ENFORCE_ENUM_SIZE = 0x7fffffff 
}; 

struct aiMemoryInfo
{
	unsigned int textures;
	unsigned int materials;
	unsigned int meshes;
	unsigned int nodes;
	unsigned int animations;
	unsigned int cameras;
	unsigned int lights;
	unsigned int total;
};

struct aiTexel
{
	unsigned char b,g,r,a;
};

struct aiTexture
{
	unsigned int mWidth;
	unsigned int mHeight;
	char achFormatHint[4];
	aiTexel* pcData;
};

#define AI_MAX_FACE_INDICES 0x7fff
#define AI_MAX_BONE_WEIGHTS 0x7fffffff
#define AI_MAX_VERTICES 0x7fffffff
#define AI_MAX_FACES 0x7fffffff
#define AI_MAX_NUMBER_OF_COLOR_SETS 0x8
#define AI_MAX_NUMBER_OF_TEXTURECOORDS 0x8

struct aiFace
{
	unsigned int mNumIndices; 
	unsigned int* mIndices;   
};

struct aiVertexWeight
{
	unsigned int mVertexId;
	float mWeight;     
};

struct aiBone
{
	aiString mName;
	unsigned int mNumWeights;
	aiVertexWeight* mWeights;
	aiMatrix4x4 mOffsetMatrix;
};
enum aiPrimitiveType
{
	aiPrimitiveType_POINT       = 0x1,
	aiPrimitiveType_LINE        = 0x2,
	aiPrimitiveType_TRIANGLE    = 0x4,
	aiPrimitiveType_POLYGON     = 0x8,
	_aiPrimitiveType_Force32Bit = 0x9fffffff
};

#define AI_PRIMITIVE_TYPE_FOR_N_INDICES(n) \
	((n) > 3 ? aiPrimitiveType_POLYGON : (aiPrimitiveType)(1u << ((n)-1)))

struct aiAnimMesh
{
	aiVector3D* mVertices;
	aiVector3D* mNormals;
	aiVector3D* mTangents;
	aiVector3D* mBitangents;
	aiColor4D* mColors[AI_MAX_NUMBER_OF_COLOR_SETS];
	aiVector3D* mTextureCoords[AI_MAX_NUMBER_OF_TEXTURECOORDS];
	unsigned int mNumVertices;
};

struct aiMesh
{
	unsigned int mPrimitiveTypes;
	unsigned int mNumVertices;
	unsigned int mNumFaces;
	aiVector3D* mVertices;
	aiVector3D* mNormals;
	aiVector3D* mTangents;
	aiVector3D* mBitangents;
	aiColor4D* mColors[AI_MAX_NUMBER_OF_COLOR_SETS];
	aiVector3D* mTextureCoords[AI_MAX_NUMBER_OF_TEXTURECOORDS];
	unsigned int mNumUVComponents[AI_MAX_NUMBER_OF_TEXTURECOORDS];
	aiFace* mFaces;
	unsigned int mNumBones;
	aiBone** mBones;
	unsigned int mMaterialIndex;
	aiString mName;
	unsigned int mNumAnimMeshes;
	aiAnimMesh** mAnimMeshes;
};

enum aiLightSourceType
{
	aiLightSource_UNDEFINED     = 0x0,
	aiLightSource_DIRECTIONAL   = 0x1,
	aiLightSource_POINT         = 0x2,
	aiLightSource_SPOT          = 0x3,
	_aiLightSource_Force32Bit = 0x9fffffff
};

struct aiLight
{
	aiString mName;
	aiLightSourceType mType;
	aiVector3D mPosition;
	aiVector3D mDirection;
	float mAttenuationConstant;
	float mAttenuationLinear;
	float mAttenuationQuadratic;
	aiColor3D mColorDiffuse;
	aiColor3D mColorSpecular;
	aiColor3D mColorAmbient;
	float mAngleInnerCone;
	float mAngleOuterCone;
};

struct aiCamera
{
	aiString mName;
	aiVector3D mPosition;
	aiVector3D mUp;
	aiVector3D mLookAt;
	float mHorizontalFOV;
	float mClipPlaneNear;
	float mClipPlaneFar;
	float mAspect;
};

#define AI_DEFAULT_MATERIAL_NAME          "DefaultMaterial"

enum aiTextureOp
{
	aiTextureOp_Multiply = 0x0,
	aiTextureOp_Add = 0x1,
	aiTextureOp_Subtract = 0x2,
	aiTextureOp_Divide = 0x3,
	aiTextureOp_SmoothAdd = 0x4,
	aiTextureOp_SignedAdd = 0x5,
	_aiTextureOp_Force32Bit = 0x9fffffff
};

enum aiTextureMapMode
{
    aiTextureMapMode_Wrap = 0x0,
    aiTextureMapMode_Clamp = 0x1,
    aiTextureMapMode_Decal = 0x3,
    aiTextureMapMode_Mirror = 0x2,
	_aiTextureMapMode_Force32Bit = 0x9fffffff
};

enum aiTextureMapping
{
    aiTextureMapping_UV = 0x0,
    aiTextureMapping_SPHERE = 0x1,
    aiTextureMapping_CYLINDER = 0x2,
    aiTextureMapping_BOX = 0x3,
    aiTextureMapping_PLANE = 0x4,
    aiTextureMapping_OTHER = 0x5,
	_aiTextureMapping_Force32Bit = 0x9fffffff
};

enum aiTextureType
{
	aiTextureType_NONE = 0x0,
    aiTextureType_DIFFUSE = 0x1,
    aiTextureType_SPECULAR = 0x2,
    aiTextureType_AMBIENT = 0x3,
    aiTextureType_EMISSIVE = 0x4,
    aiTextureType_HEIGHT = 0x5,
    aiTextureType_NORMALS = 0x6,
    aiTextureType_SHININESS = 0x7,
    aiTextureType_OPACITY = 0x8,
    aiTextureType_DISPLACEMENT = 0x9,
    aiTextureType_LIGHTMAP = 0xA,
    aiTextureType_REFLECTION = 0xB,
    aiTextureType_UNKNOWN = 0xC,
	_aiTextureType_Force32Bit = 0x9fffffff
};

#define AI_TEXTURE_TYPE_MAX  aiTextureType_UNKNOWN

enum aiShadingMode
{
    aiShadingMode_Flat = 0x1,
    aiShadingMode_Gouraud =	0x2,
    aiShadingMode_Phong = 0x3,
    aiShadingMode_Blinn	= 0x4,
    aiShadingMode_Toon = 0x5,
    aiShadingMode_OrenNayar = 0x6,
    aiShadingMode_Minnaert = 0x7,
    aiShadingMode_CookTorrance = 0x8,
    aiShadingMode_NoShading = 0x9,
    aiShadingMode_Fresnel = 0xa,
	_aiShadingMode_Force32Bit = 0x9fffffff
};

enum aiTextureFlags
{
	aiTextureFlags_Invert = 0x1,
	aiTextureFlags_UseAlpha = 0x2,
	aiTextureFlags_IgnoreAlpha = 0x4,
	  _aiTextureFlags_Force32Bit = 0x9fffffff
};

enum aiBlendMode
{
	aiBlendMode_Default = 0x0,
	aiBlendMode_Additive = 0x1,
	_aiBlendMode_Force32Bit = 0x9fffffff
};

struct aiUVTransform
{
	aiVector2D mTranslation;
	aiVector2D mScaling;
	float mRotation;
};

enum aiPropertyTypeInfo
{
    aiPTI_Float   = 0x1,
    aiPTI_String  = 0x3,
    aiPTI_Integer = 0x4,
    aiPTI_Buffer  = 0x5,
	 _aiPTI_Force32Bit = 0x9fffffff
};

struct aiMaterialProperty
{
    aiString mKey;
	unsigned int mSemantic;
	unsigned int mIndex;
    unsigned int mDataLength;
    aiPropertyTypeInfo mType;
    char* mData;
};

struct aiMaterial
{
    aiMaterialProperty** mProperties;
    unsigned int mNumProperties;
    unsigned int mNumAllocated;
};

#define AI_MATKEY_NAME "?mat.name",0,0
#define AI_MATKEY_TWOSIDED "$mat.twosided",0,0
#define AI_MATKEY_SHADING_MODEL "$mat.shadingm",0,0
#define AI_MATKEY_ENABLE_WIREFRAME "$mat.wireframe",0,0
#define AI_MATKEY_BLEND_FUNC "$mat.blend",0,0
#define AI_MATKEY_OPACITY "$mat.opacity",0,0
#define AI_MATKEY_BUMPSCALING "$mat.bumpscaling",0,0
#define AI_MATKEY_SHININESS "$mat.shininess",0,0
#define AI_MATKEY_REFLECTIVITY "$mat.reflectivity",0,0
#define AI_MATKEY_SHININESS_STRENGTH "$mat.shinpercent",0,0
#define AI_MATKEY_REFRACTI "$mat.refracti",0,0
#define AI_MATKEY_COLOR_DIFFUSE "$clr.diffuse",0,0
#define AI_MATKEY_COLOR_AMBIENT "$clr.ambient",0,0
#define AI_MATKEY_COLOR_SPECULAR "$clr.specular",0,0
#define AI_MATKEY_COLOR_EMISSIVE "$clr.emissive",0,0
#define AI_MATKEY_COLOR_TRANSPARENT "$clr.transparent",0,0
#define AI_MATKEY_COLOR_REFLECTIVE "$clr.reflective",0,0
#define AI_MATKEY_GLOBAL_BACKGROUND_IMAGE "?bg.global",0,0

#define AI_MATKEY_TEXTURE_BASE			"$tex.file"
#define AI_MATKEY_UVWSRC_BASE			"$tex.uvwsrc"
#define AI_MATKEY_TEXOP_BASE			"$tex.op"
#define AI_MATKEY_MAPPING_BASE			"$tex.mapping"
#define AI_MATKEY_TEXBLEND_BASE		"$tex.blend"
#define AI_MATKEY_MAPPINGMODE_U_BASE	"$tex.mapmodeu"
#define AI_MATKEY_MAPPINGMODE_V_BASE	"$tex.mapmodev"
#define AI_MATKEY_TEXMAP_AXIS_BASE		"$tex.mapaxis"
#define AI_MATKEY_UVTRANSFORM_BASE		"$tex.uvtrafo"
#define AI_MATKEY_TEXFLAGS_BASE		"$tex.flags"

struct aiVectorKey
{
	double mTime;     
	aiVector3D mValue; 
};

struct aiQuatKey
{
	double mTime;     
	aiQuaternion mValue; 
};

struct aiMeshKey 
{
	double mTime;
	unsigned int mValue;
};

enum aiAnimBehaviour
{
	aiAnimBehaviour_DEFAULT  = 0x0,  
	aiAnimBehaviour_CONSTANT = 0x1,
	aiAnimBehaviour_LINEAR   = 0x2,
	aiAnimBehaviour_REPEAT   = 0x3,
	_aiAnimBehaviour_Force32Bit = 0x8fffffff
};

struct aiNodeAnim
{
	aiString mNodeName;
	unsigned int mNumPositionKeys;
	aiVectorKey* mPositionKeys;
	unsigned int mNumRotationKeys;
	aiQuatKey* mRotationKeys;
	unsigned int mNumScalingKeys;
	aiVectorKey* mScalingKeys;
	aiAnimBehaviour mPreState;
	aiAnimBehaviour mPostState;
};

struct aiMeshAnim
{
	aiString mName;
	unsigned int mNumKeys;
	aiMeshKey* mKeys;
};

struct aiAnimation
{
	aiString mName;
	double mDuration;
	double mTicksPerSecond;
	unsigned int mNumChannels;
	aiNodeAnim** mChannels;
	unsigned int mNumMeshChannels;
	aiMeshAnim** mMeshChannels;
};

struct aiNode
{
	aiString mName;
	aiMatrix4x4 mTransformation;
	aiNode* mParent;
	unsigned int mNumChildren;
	aiNode** mChildren;
	unsigned int mNumMeshes;
	unsigned int* mMeshes;
};

#define AI_SCENE_FLAGS_INCOMPLETE	0x1
#define AI_SCENE_FLAGS_VALIDATED	0x2
#define AI_SCENE_FLAGS_VALIDATION_WARNING  	0x4
#define AI_SCENE_FLAGS_NON_VERBOSE_FORMAT  	0x8
#define AI_SCENE_FLAGS_TERRAIN 0x10

struct aiScene
{
	unsigned int mFlags;
	aiNode* mRootNode;
	unsigned int mNumMeshes;
	aiMesh** mMeshes;
	unsigned int mNumMaterials;
	aiMaterial** mMaterials;
	unsigned int mNumAnimations; 
	aiAnimation** mAnimations;
	unsigned int mNumTextures;
	aiTexture** mTextures;
	unsigned int mNumLights;
	aiLight** mLights;
	unsigned int mNumCameras;
	aiCamera** mCameras;
	char* mPrivate;
};

struct aiExportFormatDesc
{
	const char* id; 
	const char* description;
	const char* fileExtension;
};

struct aiExportDataBlob 
{
	size_t size;
	void* data;
	aiString name;
	aiExportDataBlob * next;
};

enum aiImporterFlags 
{
	aiImporterFlags_SupportTextFlavour = 0x1,
	aiImporterFlags_SupportBinaryFlavour = 0x2,
	aiImporterFlags_SupportCompressedFlavour = 0x4,
	aiImporterFlags_LimitedSupport = 0x8,
	aiImporterFlags_Experimental = 0x10,
};

struct aiImporterDesc 
{
	const char* mName;
	const char* mAuthor;
	const char* mMaintainer;
	const char* mComments;
	unsigned int mFlags;
	unsigned int mMinMajor;
	unsigned int mMinMinor;
	unsigned int mMaxMajor;
	unsigned int mMaxMinor;
	const char* mFileExtensions;
};

enum aiPostProcessSteps
{
	aiProcess_CalcTangentSpace = 0x1,
	aiProcess_JoinIdenticalVertices = 0x2,
	aiProcess_MakeLeftHanded = 0x4,
	aiProcess_Triangulate = 0x8,
	aiProcess_RemoveComponent = 0x10,
	aiProcess_GenNormals = 0x20,
	aiProcess_GenSmoothNormals = 0x40,
	aiProcess_SplitLargeMeshes = 0x80,
	aiProcess_PreTransformVertices = 0x100,
	aiProcess_LimitBoneWeights = 0x200,
	aiProcess_ValidateDataStructure = 0x400,
	aiProcess_ImproveCacheLocality = 0x800,
	aiProcess_RemoveRedundantMaterials = 0x1000,
	aiProcess_FixInfacingNormals = 0x2000,
	aiProcess_SortByPType = 0x8000,
	aiProcess_FindDegenerates = 0x10000,
	aiProcess_FindInvalidData = 0x20000,
	aiProcess_GenUVCoords = 0x40000,
	aiProcess_TransformUVCoords = 0x80000,
	aiProcess_FindInstances = 0x100000,
	aiProcess_OptimizeMeshes  = 0x200000, 
	aiProcess_OptimizeGraph  = 0x400000, 
	aiProcess_FlipUVs = 0x800000, 
	aiProcess_FlipWindingOrder  = 0x1000000,
	aiProcess_SplitByBoneCount  = 0x2000000,
	aiProcess_Debone  = 0x4000000
};

#define aiProcessPreset_TargetRealtime_Fast ( \
	aiProcess_CalcTangentSpace		|  \
	aiProcess_GenNormals			|  \
	aiProcess_JoinIdenticalVertices |  \
	aiProcess_Triangulate			|  \
	aiProcess_GenUVCoords           |  \
	aiProcess_SortByPType           |  \
	0 )

#define aiProcessPreset_TargetRealtime_Quality ( \
	aiProcess_CalcTangentSpace				|  \
	aiProcess_GenSmoothNormals				|  \
	aiProcess_JoinIdenticalVertices			|  \
	aiProcess_ImproveCacheLocality			|  \
	aiProcess_LimitBoneWeights				|  \
	aiProcess_RemoveRedundantMaterials      |  \
	aiProcess_SplitLargeMeshes				|  \
	aiProcess_Triangulate					|  \
	aiProcess_GenUVCoords                   |  \
	aiProcess_SortByPType                   |  \
	aiProcess_FindDegenerates               |  \
	aiProcess_FindInvalidData               |  \
	0 )

#define aiProcessPreset_TargetRealtime_MaxQuality ( \
	aiProcessPreset_TargetRealtime_Quality   |  \
	aiProcess_FindInstances                  |  \
	aiProcess_ValidateDataStructure          |  \
	aiProcess_OptimizeMeshes                 |  \
	aiProcess_Debone						 |  \
	0 )

struct aiFile;
struct aiFileIO;

typedef size_t   (*aiFileWriteProc) (aiFile*,   const char*, size_t, size_t);
typedef size_t   (*aiFileReadProc)  (aiFile*,   char*, size_t,size_t);
typedef size_t   (*aiFileTellProc)  (aiFile*);
typedef void     (*aiFileFlushProc) (aiFile*);
typedef aiReturn (*aiFileSeek)(aiFile*, size_t, aiOrigin);

typedef aiFile* (*aiFileOpenProc)  (aiFileIO*, const char*, const char*);
typedef void    (*aiFileCloseProc) (aiFileIO*, aiFile*);

typedef char* aiUserData;

struct aiFileIO
{
	aiFileOpenProc OpenProc;
	aiFileCloseProc CloseProc;
	aiUserData UserData;
};

struct aiFile
{
	aiFileReadProc ReadProc;
	aiFileWriteProc WriteProc;
	aiFileTellProc TellProc;
	aiFileTellProc FileSizeProc;
	aiFileSeek SeekProc;
	aiFileFlushProc FlushProc;
	aiUserData UserData;
};

