// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_INTERFACE_FONT_HH
#define NV_INTERFACE_FONT_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/stl/unordered_map.hh>

namespace nv
{
	struct gylph
	{
	    uint16 charcode;
		ivec2 size;
	    ivec2 offset;
	    vec2 advance;
	    vec2 tl;
	    vec2 br;
		unordered_map< uint16, float > kerning;

		gylph();
		float get_kerning( const uint16 cc );
	};

	class font
	{
	public:
		const gylph* get_gylph( uint16 charcode ) const;
	private:
		unordered_map< uint16, gylph > m_gylphs;
	};


}

#endif // NV_INTERFACE_FONT_HH
