// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file gl_window.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Window interface
 */

#ifndef NV_GL_WINDOW_HH
#define NV_GL_WINDOW_HH

#include <nv/interface/window.hh>
#include <nv/interface/window_manager.hh>
#include <nv/interface/input.hh>
#include <nv/gl/gl_context.hh>

namespace nv
{

	class gl_window : public window
	{
	public:
		gl_window( device* dev, window_manager* wm, input* a_input, void* handle, void* dc );
		virtual void set_title( const std::string& ) {}
		virtual context* get_context()    { return m_context; }
		virtual device* get_device()      { return m_device; }
		virtual uint16 get_width() const  { return m_width; }
		virtual uint16 get_height() const { return m_height; }
		virtual std::string get_title() const { return std::string(); }
		// TODO : implement?
		virtual void set_swap_control( bool ) {}

		virtual bool is_event_pending()            { return m_input->is_event_pending(); }
		virtual bool poll_event( io_event& event ) { return m_input->poll_event( event ); }

		virtual void swap_buffers();
		virtual ~gl_window();
	private:
		input*      m_input;
		device*     m_device;
		uint16      m_width;
		uint16      m_height;
		void*       m_handle;
		void*       m_hwnd;
		gl_context* m_context;

	};

} // namespace nv

#endif // NV_GL_WINDOW_HH
