#version 120

attribute vec3 nv_position;
attribute vec2 nv_texcoord;
attribute vec3 nv_normal;

varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
varying vec2 v_texcoord;

uniform mat4 nv_m_mvp;
uniform mat4 nv_m_modelview;
uniform mat4 nv_m_projection;
uniform mat3 nv_m_normal;
uniform vec3 light_position;

void main(void) {
	vec4 vertex     = vec4( nv_position, 1.0 );
	vec3 eye_pos    = vec3( nv_m_modelview * vertex );
	v_normal        = normalize( nv_m_normal * nv_normal );
	v_light_vector  = vec3( normalize( light_position - eye_pos ) );
	v_view_vector   = vec3( normalize( -eye_pos ) );

	v_texcoord      = nv_texcoord;
	gl_Position     = nv_m_mvp * vertex;
}
