// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file experimental.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief type traits - experimental
 * 
 * based on http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2015/n4502.pdf
 * and http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2014/n3911.pdf
 */

#ifndef NV_STL_TYPE_TRAITS_EXPERIMENTAL_HH
#define NV_STL_TYPE_TRAITS_EXPERIMENTAL_HH

#include <nv/stl/type_traits/common.hh>

namespace nv
{

#if NV_COMPILER == NV_MSVC
	// preferred form
	template< typename... > using void_t = void;
#else
	template< typename... > struct void_acceptor { using type = void; };
	template< typename... T > using void_t = typename void_acceptor<T...>::type;
#endif

#if NV_COMPILER == NV_MSVC
	template< bool B >
	struct match_ptr { typedef int type; };
	template< bool B >
	using match_ptr_t = typename match_ptr<B>::type;
#endif
}

#define NV_GENERATE_HAS_TYPE( TYPE ) \
template< typename, typename = nv::void_t<> > struct has_##TYPE : nv::false_type {}; \
template< typename T > struct has_##TYPE <T, nv::void_t<typename T::TYPE > > : true_type{};

#if NV_COMPILER == NV_MSVC
#define NV_VOID_DECLTYPE( EXPR ) ::nv::match_ptr_t< &EXPR >
#define NV_GENERATE_HAS_MEMBER( MEMBER ) \
template< typename, typename = nv::void_t<> > struct has_##MEMBER##_member : nv::false_type {}; \
template< typename T > struct has_##MEMBER##_member <T, nv::void_t< NV_VOID_DECLTYPE( T::MEMBER ) > > : true_type{};
#else
#define NV_VOID_DECLTYPE( EXPR ) decltype( EXPR )
#define NV_GENERATE_HAS_MEMBER( MEMBER ) \
template< typename, typename = nv::void_t<> > struct has_##MEMBER##_member : nv::false_type {}; \
template< typename T > struct has_##MEMBER##_member <T, nv::void_t< NV_VOID_DECLTYPE( T::MEMBER ) > > : true_type{};
#endif

namespace nv
{
	namespace 
	{
		struct with_type
		{
			typedef int test;
		};

		struct with_member
		{
			int test;
		};
		NV_GENERATE_HAS_TYPE( test )
		NV_GENERATE_HAS_MEMBER( test )

		static_assert( has_test< with_type >::value          == true,  "NV_GENERATE_HAS_TYPE not working (detect fail)!" );
		static_assert( has_test< with_member >::value        == false, "NV_GENERATE_HAS_TYPE not working (false positive)!" );
		static_assert( has_test_member< with_type >::value   == false, "NV_GENERATE_HAS_MEMBER not working! (false positive)!" );
		static_assert( has_test_member< with_member >::value == true,  "NV_GENERATE_HAS_MEMBER not working! (detect fail)!" );
	}
}

#endif // NV_STL_TYPE_TRAITS_EXPERIMENTAL_HH
