// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file alignment.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief type traits - alignment
 */

#ifndef NV_STL_TRAITS_ALIGNMENT_HH
#define NV_STL_TRAITS_ALIGNMENT_HH

#include <nv/stl/type_traits/common.hh>
#include <nv/stl/type_traits/properties.hh>

namespace nv
{

	namespace detail
	{
		class aligned_dummy;
		typedef void( *aligned_fptr )( );
		typedef int( aligned_dummy::*aligned_memptr );
		typedef int ( aligned_dummy::*aligned_memfptr )( );
	}

#if NV_COMPILER == NV_MSVC 
#pragma warning( push )
#pragma warning( disable : 4121 ) 
#endif		
	union max_align_t
	{
		double                  dummy0;
		long double             dummy1;
		void*                   dummy2;
		long long               dummy3;
		detail::aligned_fptr    dummy4;
		detail::aligned_memptr  dummy5;
		detail::aligned_memfptr dummy6;
	};
#if NV_COMPILER == NV_MSVC 
#pragma warning( pop )
#endif		

	template< size_t Size, size_t Align = alignof( max_align_t ) >
	struct aligned_storage
	{
		struct type
		{
			alignas( Align ) unsigned char data[ Size ];
		};
	};

	template< size_t Size, size_t Align = alignof( max_align_t ) >
	using aligned_storage_t = typename aligned_storage<Size, Align>::type;

	namespace detail
	{
		template < size_t... Sizes >
		struct size_max;

		template <>
		struct size_max < >
		{
			static constexpr size_t value = 0;
		};

		template < size_t Size >
		struct size_max < Size >
		{
			static constexpr size_t value = Size;
		};

		template < size_t S1, size_t S2, size_t... Sizes >
		struct size_max< S1, S2, Sizes... > : size_max < ( S1 < S2 ? S2 : S1 ), Sizes... > {};
	}

	template< size_t Size, typename... Types >
	struct aligned_union
	{
		static constexpr size_t max_length = detail::size_max < Size, sizeof( Types )... >::value;
		static constexpr size_t alignment_value = detail::size_max < alignment_of< Types >::value... >::value;
		using type = aligned_storage_t< max_length, alignment_value >;
	};

	template < size_t Size, typename... Types >
	using aligned_union_t = typename aligned_union<Size, Types...>::type;

}

#endif // NV_STL_TRAITS_ALIGNMENT_HH
