// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file gui_gfx_renderer.hh
* @author Kornel Kisielewicz
* @brief GUI GFX Renderer
*/

#ifndef NV_GUI_GFX_RENDERER_HH
#define NV_GUI_GFX_RENDERER_HH

#include <nv/gui/gui_renderer.hh>
#include <nv/gui/gui_style.hh>
#include <nv/interface/window.hh>
#include <nv/interface/device.hh>
#include <nv/interface/context.hh>
#include <nv/interface/camera.hh>
#include <nv/gfx/sliced_buffer.hh>
#include <nv/gfx/texture_atlas.hh>
#include <nv/gfx/texture_font.hh>

namespace nv
{
	namespace gui
	{
		struct image_info
		{
			vec2 t1;
			vec2 t2;
			ivec2 size;

			image_info() {}
			image_info( const nv::vec2 tex1, const nv::vec2 tex2, const nv::ivec2 s )
				: t1( tex1 ), t2( tex2 ), size( s )
			{
			}
		};

		class gfx_renderer : public renderer
		{
		public:
			gfx_renderer( window* w );
			virtual void redraw( element* e, uint32 );
			virtual void draw( element* e );
			virtual void draw();
			virtual void on_hover_change( element* e, bool hover );
			virtual void on_select_change( element* e, bool select );
			virtual rectangle get_area() const { return m_area; }
			virtual ~gfx_renderer();
		private:
			texture_font* get_font( size_t name ) const;
			const image_info* get_image( size_t name ) const;

			size_t load_font( const std::string& filename, size_t size );
			size_t load_image( const std::string& filename );

			typedef unordered_map< std::string, size_t > names;
			typedef vector< texture_font* >              font_vector;
			typedef vector< image_info >                 image_vector;

			context*      m_context;
			window*       m_window;
			rectangle     m_area;
			names         m_image_names;
			image_vector  m_images;
			names         m_font_names;
			font_vector   m_fonts;
			texture_atlas m_atlas;
			bool          m_reupload;

			scene_state   m_scene_state;
			render_state  m_render_state;
			render_data*  m_render_data;
		};

	}

}

#endif // NV_GUI_GFX_RENDERER_HH


