#version 120

uniform sampler2D nv_t_diffuse;
uniform vec4 light_diffuse;
uniform vec4 light_specular;

varying vec2 v_texcoord;
varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
 
void main(void) {
	vec3 nnormal         = normalize( v_normal );
	vec3 nlight_vector   = normalize( v_light_vector );
	vec3 nview_vector    = normalize( v_view_vector );
	vec3 nreflect_vector = reflect( -nlight_vector, nnormal );

	float specular_value = clamp( dot( nreflect_vector, nview_vector ), 0.0, 1.0 );
	specular_value       = pow( specular_value, 6.0 );
	float diffuse_value  = max( dot( nlight_vector, nnormal ), 0.0 );

	vec3 diff_texel      = vec3( texture2D( nv_t_diffuse, v_texcoord ) );	
	
	float final_specular = specular_value * 0.2;
	float final_diffuse  = diffuse_value * 0.5;
	float final_ambient  = 0.3;

	vec3 ambient_color   = final_ambient * diff_texel;
	vec3 diffuse_color   = light_diffuse.xyz * final_diffuse * diff_texel;
	vec3 specular_color  = light_specular.xyz * final_specular;

	gl_FragColor = vec4( ambient_color + diffuse_color + specular_color, 1.0 );
//	gl_FragColor = vec4( diff_texel, 1.0 );
}