#version 120

uniform sampler2D nv_t_diffuse;
uniform vec4 light_diffuse;
uniform vec4 light_specular;

varying vec2 v_texcoord;
varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;

void main(void) {
	vec3 diff_texel      = vec3( texture2D( nv_t_diffuse, v_texcoord ) );	

	vec3 nnormal         = normalize( v_normal );
	vec3 nlight_vector   = normalize( v_light_vector );
	vec3 nreflect_vector = reflect( -nlight_vector, nnormal );

	float specular_amount = 0.2;
	float diffuse_amount  = 1.0 - specular_amount;

	float dot_prod_specular = dot( nreflect_vector, normalize( v_view_vector ) );
	float dot_prod_diffuse  = dot( nlight_vector, nnormal );

	float diffuse_factor  = max( dot_prod_diffuse, 0.0 );
	float specular_factor = pow( max( dot_prod_specular, 0.0 ), 16.0 ); // 100.0

	float final_diffuse  = diffuse_amount * diffuse_factor * 0.5;
	float final_specular = specular_amount * specular_factor;

	vec3 diffuse_color   = light_diffuse.xyz  * final_diffuse * diff_texel;
	vec3 specular_color  = light_specular.xyz * final_specular;
	vec3 self_ilum_color = vec3 (0.0, 0.0, 0.0);
	vec3 ambient_color   = vec3 (0.0, 0.0, 0.0);

	gl_FragColor = vec4( max( self_ilum_color, diffuse_color + specular_color + ambient_color ), 1.0 );
}
