// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file std_stream.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief stream adapter for usage with STL
 */

#ifndef NV_IO_STD_STREAM_HH
#define NV_IO_STD_STREAM_HH

#include <nv/common.hh>
#include <nv/interface/stream.hh>
#include <streambuf>
#include <istream>
#include <vector>

namespace nv
{

	class std_streambuf : public std::streambuf
	{
	public:
		explicit std_streambuf( stream* source, bool owner = false, std::size_t bsize = 256, std::size_t put_back = 8 );
		virtual ~std_streambuf();
	protected:
		stream*           m_stream;
		bool              m_owner;
		std::vector<char> m_buffer;
		std::size_t       m_put_back;
	private:
		std_streambuf( const std_streambuf& );             // dissalow copy
		std_streambuf *operator =( const std_streambuf& ); // dissalow assign
		int_type underflow();
	};

	class std_stream : public std::istream
	{
	public:
		explicit std_stream( stream* source, bool owner = false, std::size_t bsize = 256, std::size_t put_back = 8 )
			: std::istream( &m_streambuf )
			, m_streambuf( source, owner, bsize, put_back ) 
		{}
	private:
		std_streambuf m_streambuf;
	};

} // namespace nv

#endif // NV_IO_STD_STREAM_HH
