// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file array.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief exception free array classes
 */

#ifndef NV_STL_ARRAY_HH
#define NV_STL_ARRAY_HH

#include <nv/stl/container/contiguous_storage.hh>
#include <nv/stl/container/contiguous_storage_policy.hh>
#include <nv/stl/container/fixed_container_handler.hh>
#include <nv/stl/container/sized_container_handler.hh>

namespace nv
{

	template< typename T, size_t N >
	using fixed_static_storage = fixed_storage< static_storage< T, N >, N >;

	template< typename T, size_t N >
	using fixed_dynamic_storage = fixed_storage< dynamic_storage< T >, N >;

	template< typename T >
	using resizable_dynamic_storage = resizable_storage< dynamic_storage< T > >;

	template< typename T, size_t N >
	using resizable_static_storage = resizable_storage< static_storage< T, N > >;

	template< typename T, size_t N >
	using array =
		detail::add_random_access <
			detail::add_iterators <
				fixed_container_handler< fixed_static_storage< T, N > > > >;
		
	template< typename T >
	using dynamic_array = 
		detail::add_random_access <
			detail::add_iterators <
				sized_container_handler< resizable_dynamic_storage< T > > > >;

}

#endif // NV_STL_ARRAY_HH
