// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

// WARNING: this file is explicitly designed to fuck with your brain

#ifndef NV_INTERFACE_INTERPOLATION_TEMPLATE_HH
#define NV_INTERFACE_INTERPOLATION_TEMPLATE_HH

#include <nv/common.hh>
#include <nv/core/transform.hh>
#include <nv/stl/math.hh>
#include <nv/interface/data_descriptor.hh>

namespace nv
{

	template < typename Key, slot Slot, bool HasKey = has_slot< Key, Slot >::value >
	struct slot_interpolator;

	template < typename Key, slot Slot >
	struct slot_interpolator< Key, Slot, false >
	{
		static void interpolate( Key&, const Key&, const Key&, float )
		{
		}
	};

	template < typename Key >
	struct slot_interpolator< Key, slot::TRANSLATION, true >
	{
		static void interpolate( Key& key, const Key& k1, const Key& k2, float factor )
		{
			key.translation = ::nv::interpolate( k1.translation, k2.translation, factor );
		}
	};

	template < typename Key >
	struct slot_interpolator< Key, slot::ROTATION, true >
	{
		static void interpolate( Key& key, const Key& k1, const Key& k2, float factor )
		{
			key.rotation = nv::interpolate( k1.rotation, k2.rotation, factor );
		}
	};

	template < typename Key >
	struct slot_interpolator< Key, slot::SCALE, true >
	{
		static void interpolate( Key& key, const Key& k1, const Key& k2, float factor )
		{
			key.scale = nv::interpolate( k1.scale, k2.scale, factor );
		}
	};

	template < typename Key >
	struct slot_interpolator< Key, slot::TFORM, true >
	{
		static void interpolate( Key& key, const Key& k1, const Key& k2, float factor )
		{
			key.tform = nv::interpolate( k1.tform, k2.tform, factor );
		}
	};

	template < typename KEY >
	void interpolate_key( KEY& key, const KEY& k1, const KEY& k2, float factor )
	{
		slot_interpolator< KEY, slot::TRANSLATION >::interpolate( key, k1, k2, factor );
		slot_interpolator< KEY, slot::ROTATION    >::interpolate( key, k1, k2, factor );
		slot_interpolator< KEY, slot::SCALE       >::interpolate( key, k1, k2, factor );
		slot_interpolator< KEY, slot::TFORM       >::interpolate( key, k1, k2, factor );
	}

	namespace detail
	{
		template < typename T >
		mat4 extract_matrix_slot( const T& ) { static_assert( sizeof( T ) == 0, "extract_matrix_slot" ); return mat4(); }
		template <> inline mat4 extract_matrix_slot( const mat4& m ) { return m; }
		template <> inline mat4 extract_matrix_slot( const transform& m ) { return m.extract(); }

		template < typename T >
		transform extract_transfrom_slot( const T& ) { static_assert( sizeof( T ) == 0, "extract_matrix_slot" ); return transform(); }
		template <> inline transform extract_transfrom_slot( const mat4& m ) { return transform(m); }
		template <> inline transform extract_transfrom_slot( const transform& m ) { return m; }

		template < typename KEY >
		mat4 extract_matrix_p_impl( const KEY& k ) { return glm::translate(mat4(),k.translation); }
		template < typename KEY >
		mat4 extract_matrix_r_impl( const KEY& k ) { return glm::mat4_cast( k.rotation ); }
		template < typename KEY >
		mat4 extract_matrix_s_impl( const KEY& k ) { return glm::scale(mat4(),k.scale); }
		template < typename KEY >
		mat4 extract_matrix_pr_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			mat4 result = glm::mat4_cast( k.rotation );
			result[3] = vec4( k.translation, 1.0f );
			return result;
		}
		template < typename KEY >
		mat4 extract_matrix_rs_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			mat4 result = glm::mat4_cast( k.rotation );
			return glm::scale(result,k.scale);
		}
		template < typename KEY >
		mat4 extract_matrix_ps_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			return glm::scale(glm::translate(mat4(),k.translation),k.scale);
		}
		template < typename KEY >
		mat4 extract_matrix_prs_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			return glm::translate(mat4(),k.translation) * glm::mat4_cast( k.rotation ) * glm::scale(mat4(),k.scale);
		}

		template < typename KEY >
		mat4 extract_matrix_prs( const KEY&, const false_type&, const false_type&, const false_type& )
		{ return mat4(); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const false_type&, const false_type& )
		{ return extract_matrix_p_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const false_type&, const true_type&, const false_type& )
		{ return extract_matrix_r_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const false_type&, const false_type&, const true_type& )
		{ return extract_matrix_s_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const true_type&, const false_type& )
		{ return extract_matrix_pr_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const false_type&, const true_type&, const true_type& )
		{ return extract_matrix_rs_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const false_type&, const true_type& )
		{ return extract_matrix_ps_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const true_type&, const true_type& )
		{ return extract_matrix_prs_impl(k); }


		template < typename KEY >
		transform extract_transform_pr_impl( const KEY&, const false_type&, const false_type& ) { return transform(); }
		template < typename KEY >
		transform extract_transform_pr_impl( const KEY& k, const true_type&, const true_type& ) { return transform( k.translation, k.rotation ); }
		template < typename KEY >
		transform extract_transform_pr_impl( const KEY& k, const true_type&, const false_type& ) { return transform( k.translation ); }
		template < typename KEY >
		transform extract_transform_pr_impl( const KEY& k, const false_type&, const true_type& ) { return transform( k.rotation ); }



		template < typename KEY >
		mat4 extract_matrix_impl( const KEY& k, const true_type& )
		{
			static_assert( has_slot< KEY, slot::TRANSLATION >::value == false, "key!");
			static_assert( has_slot< KEY, slot::ROTATION >::value == false, "key!");
			static_assert( has_slot< KEY, slot::SCALE >::value == false, "key!");
			return extract_matrix_slot( k.tform );
		}

		template < typename KEY >
		mat4 extract_matrix_impl( const KEY& k, const false_type& )
		{
			static_assert( has_slot< KEY, slot::TFORM >::value == false, "key!");
			return extract_matrix_prs( k,
				has_slot< KEY, slot::TRANSLATION >(),
				has_slot< KEY, slot::ROTATION >(),
				has_slot< KEY, slot::SCALE >()
				);
		}

		template < typename KEY >
		transform extract_transform_impl( const KEY& k, const true_type& )
		{
			static_assert( has_slot< KEY, slot::TRANSLATION >::value == false, "key!");
			static_assert( has_slot< KEY, slot::ROTATION >::value == false, "key!");
			static_assert( has_slot< KEY, slot::SCALE >::value == false, "key!");
			return extract_transfrom_slot( k.tform );
		}

		template < typename KEY >
		transform extract_transform_impl( const KEY& k, const false_type& )
		{
			static_assert( has_slot< KEY, slot::TFORM >::value == false, "key!");
			static_assert( has_slot< KEY, slot::SCALE >::value == false, "key!");
			return extract_transform_pr_impl( k, 
				has_slot< KEY, slot::TRANSLATION >(),
				has_slot< KEY, slot::ROTATION >()
				);
		}
	}

	template < typename KEY >
	mat4 extract_matrix( const KEY& k )
	{
		return detail::extract_matrix_impl( k, has_slot< KEY, slot::TFORM >() );
	}

	template < typename KEY >
	transform extract_transform( const KEY& k )
	{
		return detail::extract_transform_impl( k, has_slot< KEY, slot::TFORM >() );
	}


}

#endif // NV_INTERFACE_INTERPOLATION_TEMPLATE_HH
