// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file vector.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief exception free vector class
 */

#ifndef NV_STL_VECTOR_HH
#define NV_STL_VECTOR_HH

#include <nv/common.hh>
#include <nv/stl/container/contiguous_storage.hh>
#include <nv/stl/container/contiguous_storage_policy.hh>
#include <nv/stl/container/growing_container_handler.hh>

namespace nv
{

	template< typename T >
	using growable_dynamic_storage = growable_storage< dynamic_storage< T > >;

	template< typename T, size_t N >
	using growable_static_storage = growable_storage< static_storage< T, N > >;

	template< typename T >
	using vector = 
		detail::add_random_access <
			detail::add_iterators <
				growing_container_handler< growable_dynamic_storage< T > > > >;

}

#endif // NV_STL_VECTOR_HH
