// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file gui_renderer.hh
 * @author Kornel Kisielewicz
 * @brief GUI Renderer
 */

#ifndef NV_GUI_RENDERER_HH
#define NV_GUI_RENDERER_HH

#include <nv/common.hh>
#include <nv/core/position.hh>
#include <nv/stl/math.hh>
#include <nv/gui/gui_common.hh>
#include <nv/gui/gui_style.hh>

namespace nv
{
	namespace gui
	{
		class renderer
		{
		public:
			renderer() {}
			virtual void load_style( const std::string& filename );
			virtual void redraw( element* e, uint32 ) = 0;
			virtual void draw( element* e ) = 0;
			virtual void draw() = 0;
			virtual void on_hover_change( element* e, bool hover ) = 0;
			virtual void on_select_change( element* e, bool select ) = 0;
			virtual rectangle get_area() const = 0;
			virtual ~renderer() {}
		protected:
			style         m_style;
		};

	} // namespace gui

} // namespace nv

#endif // NV_GUI_RENDERER_HH
