// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file md2_loader.hh
 * @author Kornel Kisielewicz
 * @brief md2 loader
 */

#ifndef NV_FORMATS_MD2_LOADER_HH
#define NV_FORMATS_MD2_LOADER_HH

#include <nv/common.hh>
#include <nv/stl/vector.hh>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{

	class md2_loader : public mesh_loader
	{
	public:
		md2_loader();
		virtual ~md2_loader();
		virtual bool load( stream& source );
		virtual data_channel_set* release_mesh_data( size_t index = 0 );
		virtual mesh_data_pack* release_mesh_data_pack();
		virtual size_t get_mesh_count() const { return 1; }
	private:
		void release_mesh_frame( data_channel_set* data, sint32 frame );
		size_t get_max_frames() const;
		void reindex();
	private:
		void* m_md2;
		vector< uint16 > m_new_indexes;
		vector< uint16 > m_new_vindexes;
		vector< uint16 > m_new_tindexes;
	};

}

#endif // NV_FORMATS_MD2_LOADER_HH
