// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file gl_enum.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief GL enumerations
 */

#ifndef NV_GL_ENUM_HH
#define NV_GL_ENUM_HH

#include <nv/stl/math.hh>
#include <nv/interface/clear_state.hh>
#include <nv/interface/render_state.hh>
#include <nv/interface/image_data.hh>
#include <nv/interface/context.hh>

namespace nv
{

	unsigned int texture_type_to_enum( texture_type type );
	unsigned int clear_state_buffers_to_mask( clear_state::buffers_type type );
	unsigned int depth_state_function_to_enum( depth_test::function_type type );
	unsigned int polygon_mode_fill_to_enum( polygon_mode::fill_type type );
	unsigned int blending_factor_to_enum( blending::factor type );
	unsigned int blending_equation_to_enum( blending::equation type );
	unsigned int culling_face_type_to_enum( culling::face_type type );
	unsigned int culling_order_type_to_enum( culling::order_type type );
	unsigned int stencil_function_to_enum( stencil_test_face::function_type type );
	unsigned int stencil_operation_to_enum( stencil_test_face::operation type );
	unsigned int buffer_hint_to_enum( buffer_hint hint );
	unsigned int buffer_type_to_enum( buffer_type type );
	unsigned int image_format_to_enum( pixel_format format );
	unsigned int image_format_to_internal_enum( pixel_format format );
	unsigned int sampler_filter_to_enum( sampler::filter filter );
	unsigned int sampler_wrap_to_enum( sampler::wrap wrap );
	unsigned int primitive_to_enum( primitive p );
	unsigned int framebuffer_slot_to_enum( framebuffer_slot slot );
	unsigned int output_slot_to_enum( output_slot slot );

	unsigned int datatype_to_gl_enum( datatype type );
	datatype gl_enum_to_datatype( unsigned int gl_enum );
	std::string datatype_to_glsl_type( datatype type );

} // namespace nv

#endif // NV_GL_ENUM_HH
