// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

// WARNING: this file is explicitly designed to fuck with your brain

#ifndef NV_INTERFACE_INTERPOLATION_RAW_HH
#define NV_INTERFACE_INTERPOLATION_RAW_HH

#include <nv/common.hh>
#include <nv/core/transform.hh>
#include <nv/stl/math.hh>
#include <nv/interface/data_descriptor.hh>

namespace nv
{

	inline uint32 interpolate_raw_linear( uint32 count, float factor, const float* k1, const float* k2, float* result )
	{
		for ( uint32 i = 0; i < count; ++i )
		{
			result[i] = k1[i] + factor * (k2[i] - k1[i]); 
		}
		return count;
	}

	inline uint32 interpolate_raw_quat( float factor, const float* k1, const float* k2, float* result )
	{
		*( reinterpret_cast<quat*>(result) ) = interpolate( *( reinterpret_cast<const quat*>(k1) ), *( reinterpret_cast<const quat*>(k2) ), factor );
		return 4;
	}

	inline uint32 interpolate_raw( const data_descriptor_slot& slot, float factor, const float* k1, const float* k2, float* result )
	{
		uint32 count = get_datatype_info( slot.etype ).elements;
		switch ( slot.vslot )
		{
		case slot::TIME:        return 0;
		case slot::TRANSLATION: return interpolate_raw_linear( count, factor, k1, k2, result );
		case slot::ROTATION:    return interpolate_raw_quat( factor, k1, k2, result );
		case slot::SCALE:       return interpolate_raw_linear( count, factor, k1, k2, result );
		case slot::TFORM:       return 
										   interpolate_raw_linear( 3, factor, k1, k2, result ) + 
										   interpolate_raw_quat( factor, k1 + 3, k2 + 3, result + 3 );
		default:
			return 0;
		};
	}

	inline quat make_quat_fixed( const float* data )
	{
		quat result;
		memcpy(reinterpret_cast<float*>(&result), data, sizeof(quat));
		return result;
	}

	inline mat4 extract_matrix_raw( const data_descriptor& desc, const float* data )
	{
		if ( desc.slot_count() == 1 )
		{
			switch ( desc[0].vslot )
			{
			case slot::TIME:        return mat4();
			case slot::TRANSLATION: return glm::translate( mat4(), make_vec3( data ) );
			case slot::ROTATION:    return mat4_cast( make_quat_fixed( data ) );
			case slot::SCALE:       return glm::scale( mat4(),make_vec3( data ) );
			case slot::TFORM:       return transform( make_vec3( data ), make_quat_fixed( data + 3 ) ).extract();
			default:
				return mat4();
			};
		}
		else
		{
			mat4 translation;
			mat4 rotation;
			mat4 scale;
			for ( auto& slot : desc )
			{
				uint32 offset = slot.offset / 4;
				switch ( slot.vslot )
				{
				case slot::TIME:     break;
				case slot::TRANSLATION:
					translation = glm::translate( translation,make_vec3( data + offset ) ); break;
				case slot::ROTATION: 
					rotation = mat4_cast( make_quat_fixed( data + offset ) ); break;
				case slot::SCALE:    
					scale    = glm::scale( mat4(),make_vec3( data + offset ) ); break;
				case slot::TFORM:    return transform( make_vec3( data + offset ), make_quat_fixed( data + offset + 3 ) ).extract();
				default:
					break;
				}
			}
			return translation * rotation * scale;
		}
	}

	inline transform extract_transform_raw( const data_descriptor& desc, const float* data )
	{
		if ( desc.slot_count() == 1 )
		{
			switch ( desc[0].vslot )
			{
			case slot::TIME:        return transform();
			case slot::TRANSLATION: return transform( make_vec3( data ) );
			case slot::ROTATION:    return transform( make_quat_fixed( data ) );
			case slot::SCALE:       return transform();
			case slot::TFORM:       return transform( make_vec3( data ), make_quat_fixed( data + 3 ) );
			default:
				return transform();
			};
		}
		else
		{
			vec3 translation;
			quat rotation;
			for ( auto& slot : desc )
			{
				uint32 offset = slot.offset / 4;
				switch ( slot.vslot )
				{
				case slot::TIME:     break;
				case slot::TRANSLATION:
					translation = make_vec3( data + offset ); break;
				case slot::ROTATION: 
					rotation = make_quat_fixed( data + offset ); break;
				case slot::SCALE:	   break;
				case slot::TFORM:    return transform( make_vec3( data + offset ), make_quat_fixed( data + 3 ) );
				default:
					break;
				}
			}
			return transform( translation, rotation );
		}
	}

	inline void transform_key_translation( uint8* data, float scale, const mat3& r33 )
	{
		vec3& p = *( reinterpret_cast<vec3*>( data ) );
		p = r33 * p * scale;
	}
	inline void transform_key_rotation( uint8* data, const mat3& r33, const mat3& ri33 )
	{
		quat& r = *( reinterpret_cast<quat*>( data ) );
		r = quat_cast( r33 * mat3_cast( r ) * ri33 );
	}
	inline void transform_key_scale( void* data, float scale )
	{
		vec3& s = *( reinterpret_cast<vec3*>( data ) );
		s = s * scale;
	}
	inline void transform_key_transform( uint8* data, float scale, const mat3& r33, const mat3& ri33 )
	{
		transform& t = *( reinterpret_cast<transform*>( data ) );
		t = transform( 
			r33 * t.get_position() * scale,
			quat_cast( r33 * mat3_cast( t.get_orientation() ) * ri33 )
		);
	}

	inline void transform_key_raw( const data_descriptor& desc, uint8* data, float scale, const mat3& r33, const mat3& ri33 )
	{
		for ( auto& slot : desc )
		{
			uint32 offset = slot.offset / 4;
			switch ( slot.vslot )
			{
			case slot::TIME:     break;
			case slot::TRANSLATION: transform_key_translation( data + offset, scale, r33 ); break;
			case slot::ROTATION:    transform_key_rotation( data + offset, r33, ri33 ); break;
			case slot::SCALE:       transform_key_scale( data + offset, scale ); break;
			case slot::TFORM:       transform_key_transform( data + offset, scale, r33, ri33 ); break;
			default:
				break;
			}
		}
	}

}

#endif // NV_INTERFACE_INTERPOLATION_RAW_HH
