// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file rtti_types.hh
 * @author Kornel Kisielewicz
 * @brief RTTI emulation - basic types
 */

#ifndef NV_STL_RTTI_TYPES_HH
#define NV_STL_RTTI_TYPES_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>

NV_RTTI_DECLARE( void )
NV_RTTI_DECLARE( bool )
NV_RTTI_DECLARE( char )
NV_RTTI_DECLARE_NAME( nv::sint8, "sint8" )
NV_RTTI_DECLARE_NAME( nv::uint8, "uint8" )
NV_RTTI_DECLARE_NAME( nv::sint16, "sint16" )
NV_RTTI_DECLARE_NAME( nv::uint16, "uint16" )
NV_RTTI_DECLARE_NAME( nv::sint32, "sint32" )
NV_RTTI_DECLARE_NAME( nv::uint32, "uint32" )
NV_RTTI_DECLARE_NAME( nv::sint64, "sint64" )
NV_RTTI_DECLARE_NAME( nv::uint64, "uint64" )
NV_RTTI_DECLARE_NAME( nv::f32, "f32" )
NV_RTTI_DECLARE_NAME( nv::f64, "f64" )
NV_RTTI_DECLARE( nv::vec2 )
NV_RTTI_DECLARE( nv::vec3 )
NV_RTTI_DECLARE( nv::vec4 )
NV_RTTI_DECLARE( nv::ivec2 )
NV_RTTI_DECLARE( nv::ivec3 )
NV_RTTI_DECLARE( nv::ivec4 )
NV_RTTI_DECLARE( nv::mat2 )
NV_RTTI_DECLARE( nv::mat3 )
NV_RTTI_DECLARE( nv::mat4 )
NV_RTTI_DECLARE( nv::quat )

#endif // NV_STL_RTTI_TYPES_HH
