// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file initialize_policy.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief initialize policies
*/

#ifndef NV_STL_INITIALIZE_POLICY_HH
#define NV_STL_INITIALIZE_POLICY_HH

#include <nv/common.hh>
#include <nv/stl/memory.hh>

namespace nv
{

	struct default_init
	{

	};

	struct policy_initialize_always
	{
		template < typename ForwardIterator >
		inline static void initialize( ForwardIterator first, ForwardIterator last )
		{
			uninitialized_construct( first, last );
		}
		template < typename InputIterator, typename ForwardIterator >
		inline static ForwardIterator copy( InputIterator first, InputIterator last, ForwardIterator out )
		{
			return uninitialized_copy( first, last, out );
		}
		template < typename ForwardIterator >
		inline static void destroy( ForwardIterator first, ForwardIterator last )
		{
			uninitialized_destroy( first, last );
		}
		template < typename ForwardIterator >
		inline static void destroy( ForwardIterator first )
		{
			destroy_object( first );
		}
	};

	struct policy_initialize_never
	{
		template < typename ForwardIterator >
		inline static void initialize( ForwardIterator, ForwardIterator )
		{
		}
		template < typename InputIterator, typename ForwardIterator >
		inline static ForwardIterator copy( InputIterator first, InputIterator last, ForwardIterator out )
		{
			return detail::uninitialized_copy_impl( first, last, out, true_type() );
		}
		template < typename ForwardIterator >
		inline static void destroy( ForwardIterator, ForwardIterator )
		{
		}
		template < typename ForwardIterator >
		inline static void destroy( ForwardIterator )
		{
		}
	};

	struct policy_initialize_standard
	{
		template < typename ForwardIterator >
		inline static void initialize( ForwardIterator first, ForwardIterator last )
		{
			typedef typename iterator_traits< ForwardIterator >::value_type value_type;
			if ( !has_trivial_constructor<value_type>() )
				detail::uninitialized_construct_impl( first, last, false_type() );
		}
		template < typename InputIterator, typename ForwardIterator >
		inline static ForwardIterator copy( InputIterator first, InputIterator last, ForwardIterator out )
		{
			return uninitialized_copy( first, last, out );
		}
		template < typename ForwardIterator >
		inline static void destroy( ForwardIterator first, ForwardIterator last )
		{
			typedef typename iterator_traits< ForwardIterator >::value_type value_type;
			if ( !has_trivial_destructor<value_type>() )
				detail::uninitialized_destroy_impl( first, last, false_type() );
		}
		template < typename ForwardIterator >
		inline static void destroy( ForwardIterator first )
		{
			typedef typename iterator_traits< ForwardIterator >::value_type value_type;
			if ( !has_trivial_destructor<value_type>() )
				destroy_object( first );
		}
	};

}

#endif // NV_STL_INITIALIZE_POLICY_HH
