// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file window_manager.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Window Manager interface
 */

#ifndef NV_INTERFACE_WINDOW_MANAGER_HH
#define NV_INTERFACE_WINDOW_MANAGER_HH

#include <nv/common.hh>
#include <nv/stl/string.hh>

namespace nv
{
	class context;
	class device;
	class window;
	class image_data;

	class window_manager
	{
	public:
		virtual window* create_window( device* dev, uint16 width, uint16 height, bool fullscreen ) = 0;
		virtual void* adopt_window( void* sys_w_handle ) = 0;
		virtual void sleep( uint32 ms ) = 0;
		virtual uint32 get_ticks() = 0;
		virtual ~window_manager() {}
	};

}

#endif // NV_INTERFACE_WINDOW_MANAGER_HH
