// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/engine/resource_system.hh"
#include "nv/stl/range.hh"
#include "nv/lua/lua_nova.hh"

void nv::resource_manager_base::initialize( lua::state* a_lua_state )
{
	m_lua = a_lua_state;
	lua::register_storage( m_lua, get_storage_name(), string_view( "register_" + get_resource_name().to_string() ) );
}

nv::resource_id nv::resource_manager_base::load_resource( const std::string& id )
{
	lua::table_guard table( m_lua, lua::path( get_storage_name(), id ) );
	resource_id rid = load_resource( table );
	if ( rid != 0 ) m_names[ id ] = rid;
	return rid;
}

void nv::resource_manager_base::load_all()
{
	clear();
	lua::table_guard table( m_lua, get_storage_name() );
	uint32 count = table.get_unsigned( "__counter" );
	for ( auto i : range( count ) )
	{
		lua::table_guard sub_table( table, i+1 );
		resource_id rid = load_resource( sub_table );
		if ( rid != 0 ) m_names[ sub_table.get_std_string("id") ] = rid;
	}
}

nv::resource_type_id nv::resource_system::register_resource_type( const std::string& /*name*/, resource_manager_base* /*manager*/ )
{
	return 0;
}

nv::resource_type_id nv::resource_system::get_resource_type_id( const std::string& /*name*/ ) const
{
	return 0;
}

void nv::resource_system::initialize( lua::state* /*a_lua_state*/ )
{

}

nv::resource_system::~resource_system()
{

}
