// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/io/c_file_system.hh"
#include "nv/io/c_stream.hh"
#include <cstdio>

using namespace nv;

c_file_system::c_file_system()
{

}

c_file_system::~c_file_system()
{

}

bool c_file_system::exists( const char* fpath )
{
	FILE* file = ::fopen( fpath, "rb" );
	if ( !file )
	{
		return false;
	}
	::fclose( file );
	return true;
}

stream* c_file_system::open( const char* fpath, const char* fmode /*= "rb" */ )
{
	NV_ASSERT( fpath != nullptr && fmode != nullptr, "Bad parameters passed to open" );
	FILE* file = ::fopen( fpath, fmode );
	if ( !file )
	{
		return nullptr;
	}
	return new c_stream( file, fpath );
}
