// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

// WARNING: this file is explicitly designed to fuck with your brain

#ifndef NV_INTERFACE_INTERPOLATION_TEMPLATE_HH
#define NV_INTERFACE_INTERPOLATION_TEMPLATE_HH

#include <nv/common.hh>
#include <nv/core/transform.hh>
#include <nv/stl/math.hh>
#include <nv/interface/animation_key.hh>

namespace nv
{

	template < typename KEY, animation_slot SLOT > 
	void interpolate_slot( KEY& key, const KEY& k1, const KEY& k2, float factor, const true_type& )
	{
		key_slot_info< KEY, SLOT >::interpolate( key, k1, k2, factor );
	}

	template < typename KEY, animation_slot SLOT > 
	void interpolate_slot( KEY&, const KEY&, const KEY&, float, const false_type& )
	{
	}

	template < typename KEY >
	void interpolate_key( KEY& key, const KEY& k1, const KEY& k2, float factor )
	{
		interpolate_slot< KEY, animation_slot::POSITION >( key, k1, k2, factor, key_has_slot< KEY, animation_slot::POSITION >() );
		interpolate_slot< KEY, animation_slot::ROTATION >( key, k1, k2, factor, key_has_slot< KEY, animation_slot::ROTATION >() );
		interpolate_slot< KEY, animation_slot::SCALE >( key, k1, k2, factor, key_has_slot< KEY, animation_slot::SCALE >() );
		interpolate_slot< KEY, animation_slot::TFORM >( key, k1, k2, factor, key_has_slot< KEY, animation_slot::TFORM >() );
	}

	namespace detail
	{
		template < typename T >
		mat4 extract_matrix_slot( const T& ) { static_assert( sizeof( T ) == 0, "extract_matrix_slot" ); return mat4(); }
		template <> inline mat4 extract_matrix_slot( const mat4& m ) { return m; }
		template <> inline mat4 extract_matrix_slot( const transform& m ) { return m.extract(); }

		template < typename T >
		transform extract_transfrom_slot( const T& ) { static_assert( sizeof( T ) == 0, "extract_matrix_slot" ); return transform(); }
		template <> inline transform extract_transfrom_slot( const mat4& m ) { return transform(m); }
		template <> inline transform extract_transfrom_slot( const transform& m ) { return m; }

		template < typename KEY >
		mat4 extract_matrix_p_impl( const KEY& k ) { return glm::translate(mat4(),k.position); }
		template < typename KEY >
		mat4 extract_matrix_r_impl( const KEY& k ) { return glm::mat4_cast( k.rotation ); }
		template < typename KEY >
		mat4 extract_matrix_s_impl( const KEY& k ) { return glm::scale(mat4(),k.scale); }
		template < typename KEY >
		mat4 extract_matrix_pr_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			mat4 result = glm::mat4_cast( k.rotation );
			result[3] = vec4( k.position, 1.0f );
			return result;
		}
		template < typename KEY >
		mat4 extract_matrix_rs_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			mat4 result = glm::mat4_cast( k.rotation );
			return glm::scale(result,k.scale);
		}
		template < typename KEY >
		mat4 extract_matrix_ps_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			return glm::scale(glm::translate(mat4(),k.position),k.scale);
		}
		template < typename KEY >
		mat4 extract_matrix_prs_impl( const KEY& k )
		{
			// TODO: this is obviously unoptimized
			return glm::translate(mat4(),k.position) * glm::mat4_cast( k.rotation ) * glm::scale(mat4(),k.scale);
		}

		template < typename KEY >
		mat4 extract_matrix_prs( const KEY&, const false_type&, const false_type&, const false_type& )
		{ return mat4(); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const false_type&, const false_type& )
		{ return extract_matrix_p_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const false_type&, const true_type&, const false_type& )
		{ return extract_matrix_r_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const false_type&, const false_type&, const true_type& )
		{ return extract_matrix_s_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const true_type&, const false_type& )
		{ return extract_matrix_pr_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const false_type&, const true_type&, const true_type& )
		{ return extract_matrix_rs_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const false_type&, const true_type& )
		{ return extract_matrix_ps_impl(k); }
		template < typename KEY >
		mat4 extract_matrix_prs( const KEY& k, const true_type&, const true_type&, const true_type& )
		{ return extract_matrix_prs_impl(k); }


		template < typename KEY >
		transform extract_transform_pr_impl( const KEY&, const false_type&, const false_type& ) { return transform(); }
		template < typename KEY >
		transform extract_transform_pr_impl( const KEY& k, const true_type&, const true_type& ) { return transform( k.position, k.rotation ); }
		template < typename KEY >
		transform extract_transform_pr_impl( const KEY& k, const true_type&, const false_type& ) { return transform( k.position ); }
		template < typename KEY >
		transform extract_transform_pr_impl( const KEY& k, const false_type&, const true_type& ) { return transform( k.rotation ); }



		template < typename KEY >
		mat4 extract_matrix_impl( const KEY& k, const true_type& )
		{
			static_assert( key_has_slot< KEY, animation_slot::POSITION >::value == false, "key!");
			static_assert( key_has_slot< KEY, animation_slot::ROTATION >::value == false, "key!");
			static_assert( key_has_slot< KEY, animation_slot::SCALE >::value == false, "key!");
			return extract_matrix_slot( k.tform );
		}

		template < typename KEY >
		mat4 extract_matrix_impl( const KEY& k, const false_type& )
		{
			static_assert( key_has_slot< KEY, animation_slot::TFORM >::value == false, "key!");
			return extract_matrix_prs( k,
				key_has_slot< KEY, animation_slot::POSITION >(),
				key_has_slot< KEY, animation_slot::ROTATION >(),
				key_has_slot< KEY, animation_slot::SCALE >()
				);
		}

		template < typename KEY >
		transform extract_transform_impl( const KEY& k, const true_type& )
		{
			static_assert( key_has_slot< KEY, animation_slot::POSITION >::value == false, "key!");
			static_assert( key_has_slot< KEY, animation_slot::ROTATION >::value == false, "key!");
			static_assert( key_has_slot< KEY, animation_slot::SCALE >::value == false, "key!");
			return extract_transfrom_slot( k.tform );
		}

		template < typename KEY >
		transform extract_transform_impl( const KEY& k, const false_type& )
		{
			static_assert( key_has_slot< KEY, animation_slot::TFORM >::value == false, "key!");
			static_assert( key_has_slot< KEY, animation_slot::SCALE >::value == false, "key!");
			return extract_transform_pr_impl( k, 
				key_has_slot< KEY, animation_slot::POSITION >(),
				key_has_slot< KEY, animation_slot::ROTATION >()
				);
		}
	}

	template < typename KEY >
	mat4 extract_matrix( const KEY& k )
	{
		return detail::extract_matrix_impl( k, key_has_slot< KEY, animation_slot::TFORM >() );
	}

	template < typename KEY >
	transform extract_transform( const KEY& k )
	{
		return detail::extract_transform_impl( k, key_has_slot< KEY, animation_slot::TFORM >() );
	}


}

#endif // NV_INTERFACE_INTERPOLATION_TEMPLATE_HH
