// Copyright (C) 2013-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#include "nv/lib/curses.hh"

#if defined( NV_CURSES_DYNAMIC )

#include "nv/core/library.hh"

#define FILE void
#define NV_CURSES_FUN( rtype, fname, fparams ) rtype (*fname) fparams = nullptr;
#include <nv/lib/detail/curses_functions.inc>
#undef NV_CURSES_FUN

bool nv::load_curses_library( const char* path )
{
	static nv::library curses_library;
	if ( curses_library.is_open() ) return true;
	curses_library.open( path );

#	define NV_CURSES_FUN( rtype, fname, fparams ) *(void **) (&::fname) = curses_library.get(#fname);
#	include <nv/lib/detail/curses_functions.inc>
#	undef NV_CURSES_FUN
	return true;
}
#endif
