// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
* @file raw.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief algorithm raw
*/

#ifndef NV_STL_ALGORITHM_RAW_HH
#define NV_STL_ALGORITHM_RAW_HH

#include <nv/stl/algorithm/common.hh>
#include <nv/base/capi.hh>

namespace nv
{

	template< typename T >
	T* raw_copy( const T* first, const T* last, T* out )
	{
		return (T*)nvmemcpy( out, first, (size_t)( (uintptr_t)last - (uintptr_t)first ) ) + ( last - first );
	}

	template< typename T >
	T* raw_copy_n( const T* ptr, size_t n, T* out )
	{
		return (T*)nvmemcpy( out, ptr, n * sizeof( T ) ) + n;
	}

	template< typename T >
	T* raw_alias_copy( const T* first, const T* last, T* out )
	{
		return (T*)nvmemmove( out, first, (size_t)( (uintptr_t)last - (uintptr_t)first ) ) + ( last - first );
	}

	template< typename T >
	T* raw_alias_copy_n( const T* ptr, size_t n, T* out )
	{
		return (T*)nvmemmove( out, ptr, n * sizeof( T ) ) + n;
	}

	template< typename T >
	T* raw_zero( T* first, T* last )
	{
		return (T*)nvmemset( first, 0, (size_t)( (uintptr_t)last - (uintptr_t)first ) ) + ( last - first );
	}

	template< typename T >
	T* raw_zero_n( T* ptr, size_t n )
	{
		return (T*)nvmemset( ptr, 0, n * sizeof( T ) ) + n;
	}

	template< typename T >
	T* raw_fill( T* first, T* last, unsigned char value )
	{
		return (T*)nvmemset( first, value, (size_t)( (uintptr_t)last - (uintptr_t)first ) ) + ( last - first );
	}

	template< typename T >
	T* raw_fill_n( T* ptr, size_t n, unsigned char value )
	{
		return (T*)nvmemset( ptr, value, n * sizeof( T ) ) + n;
	}

}

#endif // NV_STL_ALGORITHM_RAW_HH

