// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file sdl_window_manager.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief SDL Window manager implementation
 */

#ifndef NV_SDL_WINDOW_MANAGER_HH
#define NV_SDL_WINDOW_MANAGER_HH

#include <nv/interface/window_manager.hh>
#include <nv/interface/input.hh>

namespace nv
{

	namespace sdl
	{
		class window_manager : public nv::window_manager
		{
		public:
			window_manager();
			virtual nv::window* create_window( device* dev, uint16 width, uint16 height, bool fullscreen );
			virtual void* adopt_window( void* sys_w_handle );
			virtual void sleep( uint32 ms );
			virtual uint32 get_ticks();
			virtual ~window_manager();
		};
	}

}

#endif // NV_SDL_WINDOW_MANAGER_HH