// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#ifndef NV_LIB_LUA_HH
#define NV_LIB_LUA_HH

// Portions of the official Lua 5.2 headers were used, copyright follows:

/******************************************************************************
* Copyright (C) 1994-2012 Lua.org, PUC-Rio.
*
* Permission is hereby granted, free of charge, to any person obtaining
* a copy of this software and associated documentation files (the
* "Software"), to deal in the Software without restriction, including
* without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to
* permit persons to whom the Software is furnished to do so, subject to
* the following conditions:
*
* The above copyright notice and this permission notice shall be
* included in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
******************************************************************************/

#include <nv/common.hh>

#define NV_LUA_DYNAMIC
//#define NV_LUA_SHARED

#define NV_LUA_5C     0
#define NV_LUA_51     1
#define NV_LUA_52     2

#if NV_PLATFORM == NV_WINDOWS
#	define NV_LUA_PATH_51  "lua51.dll"
#	define NV_LUA_PATH_52  "lua52.dll"
#	define NV_LUA_PATH_JIT "luajit.dll"
#elif NV_PLATFORM == NV_APPLE
#	define NV_LUA_PATH_51  "lua5.1.dylib"
#	define NV_LUA_PATH_52  "lua5.2.dylib"
#	define NV_LUA_PATH_JIT "luajit.dylib"
#else
#	define NV_LUA_PATH_51  "lua5.1.so"
#	define NV_LUA_PATH_52  "lua5.2.so"
#	define NV_LUA_PATH_JIT "luajit.so"
#endif


#if !defined(NV_LUA_VERSION)
#	define NV_LUA_VERSION     NV_LUA_5C
#endif

#if defined(NV_LUA_JIT)
#	if NV_LUA_VERSION == NV_LUA_52
#		error "LuaJIT requested with version 5.2!"
#	endif
#endif

#if NV_LUA_VERSION == NV_LUA_52
#	define NV_LUA_PATH NV_LUA_PATH_52
#elif NV_LUA_VERSION == NV_LUA_51 
#	define NV_LUA_PATH NV_LUA_PATH_51
#elif NV_LUA_VERSION == NV_LUA_5C
#	define NV_LUA_PATH nullptr
#else
#	error "Unrecognized NV_LUA_VERSION!"
#endif

#if defined(NV_LUA_JIT)
#	define NV_LUA_PATH NV_LUA_PATH_JIT
#endif

#include <limits.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>

extern "C" {

#if defined(NV_LUA_SHARED) && (NV_PLATFORM == NV_WINDOWS)
#	define NV_LUA_API __declspec(dllimport)
#else
#	define NV_LUA_API extern
#endif

/* luaconf.h definitions (only the ones needed in the headers) */
#define LUA_NUMBER   double
#define LUA_INTEGER  ptrdiff_t
#define LUA_UNSIGNED unsigned int

#define LUA_IDSIZE 60

/* lua.h */
#define LUA_VERSION_MAJOR	"5"
#if NV_LUA_VERSION == NV_LUA_52
#	define LUA_VERSION_MINOR	"2"
#	define LUA_VERSION_NUM		502
#	define LUA_VERSION_RELEASE	"1"
#elif NV_LUA_VERSION == NV_LUA_51
#	define LUA_VERSION_MINOR	"1"
#	define LUA_VERSION_NUM		501
#	define LUA_VERSION_RELEASE	"4"
#else
#	define LUA_VERSION_MINOR	"?"
#	define LUA_VERSION_RELEASE	"?"
#endif 

#define LUA_VERSION	"Lua " LUA_VERSION_MAJOR "." LUA_VERSION_MINOR
#define LUA_RELEASE	LUA_VERSION "." LUA_VERSION_RELEASE
#define LUA_COPYRIGHT	LUA_RELEASE "  Copyright (C) 1994-2012 Lua.org, PUC-Rio"
#define LUA_AUTHORS	"R. Ierusalimschy, L. H. de Figueiredo, W. Celes"

#define LUA_SIGNATURE	"\033Lua"
#define LUA_MULTRET	(-1)
#define LUA_NOREF       (-2)
#define LUA_REFNIL      (-1)

#if NV_LUA_VERSION == NV_LUA_52
#	define LUAI_MAXSTACK		1000000
#	define LUAI_FIRSTPSEUDOIDX	(-LUAI_MAXSTACK - 1000)
#	define LUA_REGISTRYINDEX	LUAI_FIRSTPSEUDOIDX
#	define lua_upvalueindex(i)	(LUA_REGISTRYINDEX - (i))
#elif NV_LUA_VERSION == NV_LUA_51
#	define LUA_REGISTRYINDEX      (-10000)
#	define LUA_ENVIRONINDEX       (-10001)
#	define LUA_GLOBALSINDEX       (-10002)
#	define lua_upvalueindex(i)    (LUA_GLOBALSINDEX-(i))
#else
#endif

#define LUAL_BUFFERSIZE		BUFSIZ

/* Types */
typedef struct lua_State lua_State;
typedef struct lua_Debug lua_Debug; 
typedef int (*lua_CFunction) (lua_State *L);
typedef const char * (*lua_Reader) (lua_State *L, void *ud, size_t *sz);
typedef int (*lua_Writer) (lua_State *L, const void* p, size_t sz, void* ud);
typedef void * (*lua_Alloc) (void *ud, void *ptr, size_t osize, size_t nsize);
typedef void (*lua_Hook) (lua_State *L, lua_Debug *ar);

struct lua_Debug {
  int event;
  const char *name;	/* (n) */
  const char *namewhat;	/* (n) 'global', 'local', 'field', 'method' */
  const char *what;	/* (S) 'Lua', 'C', 'main', 'tail' */
  const char *source;	/* (S) */
  int currentline;	/* (l) */
#if NV_LUA_VERSION == NV_LUA_52
  int linedefined;	/* (S) */
  int lastlinedefined;	/* (S) */
  unsigned char nups;	/* (u) number of upvalues */
  unsigned char nparams;/* (u) number of parameters */
  char isvararg;        /* (u) */
  char istailcall;	/* (t) */
  char short_src[LUA_IDSIZE]; /* (S) */
  struct CallInfo *i_ci;  /* active function */
#elif NV_LUA_VERSION == NV_LUA_51
  int nups;
  int linedefined;	/* (S) */
  int lastlinedefined;	/* (S) */
  char short_src[LUA_IDSIZE]; /* (S) */
  int i_ci;  /* active function */
#else
#endif
};

/* Aux lib structs */
typedef struct luaL_Reg {
  const char *name;
  lua_CFunction func;
} luaL_Reg;

/* TODO: make compat version - two buffers, decision at load time */
#if NV_LUA_VERSION == NV_LUA_52
typedef struct luaL_Buffer {
	char *b;  /* buffer address */
	size_t size;  /* buffer size */
	size_t n;  /* number of characters in buffer */
	lua_State *L;
	char initb[LUAL_BUFFERSIZE];  /* initial buffer */
} luaL_Buffer;
#elif NV_LUA_VERSION == NV_LUA_51
typedef struct luaL_Buffer {
	char *p;
	int lvl;
	lua_State *L;
	char initb[LUAL_BUFFERSIZE];
} luaL_Buffer;
#else
#endif

#if NV_LUA_VERSION == NV_LUA_52
typedef struct luaL_Stream {
  FILE *f;  /* stream (NULL for incompletely created streams) */
  lua_CFunction closef;  /* to close stream (NULL for closed streams) */
} luaL_Stream;
#endif

typedef LUA_NUMBER lua_Number;
typedef LUA_INTEGER lua_Integer;
typedef LUA_UNSIGNED lua_Unsigned;

/* Thread return codes */
#define LUA_OK		0
#define LUA_YIELD	1
#define LUA_ERRRUN	2
#define LUA_ERRSYNTAX	3
#define LUA_ERRMEM	4
#if NV_LUA_VERSION == NV_LUA_52
#	define LUA_ERRGCMM	5
#	define LUA_ERRERR	6
#	define LUA_ERRFILE  7
#elif NV_LUA_VERSION == NV_LUA_51
#	define LUA_ERRERR	5
#	define LUA_ERRFILE  6
#else
#endif

/* Type codes */
#define LUA_TNONE			(-1)
#define LUA_TNIL			0
#define LUA_TBOOLEAN		1
#define LUA_TLIGHTUSERDATA	2
#define LUA_TNUMBER			3
#define LUA_TSTRING			4
#define LUA_TTABLE			5
#define LUA_TFUNCTION		6
#define LUA_TUSERDATA		7
#define LUA_TTHREAD			8

#if NV_LUA_VERSION == NV_LUA_52
#	define LUA_NUMTAGS			9
#endif
#define LUA_MINSTACK		20

#if NV_LUA_VERSION == NV_LUA_52
/* Pre-defined registers */
#	define LUA_RIDX_MAINTHREAD	1
#	define LUA_RIDX_GLOBALS	2
#	define LUA_RIDX_LAST		LUA_RIDX_GLOBALS
#endif

#if NV_LUA_VERSION == NV_LUA_52
/* OP codes */
#	define LUA_OPADD	0
#	define LUA_OPSUB	1
#	define LUA_OPMUL	2
#	define LUA_OPDIV	3
#	define LUA_OPMOD	4
#	define LUA_OPPOW	5
#	define LUA_OPUNM	6
#endif

/* Compare codes */
#if NV_LUA_VERSION == NV_LUA_52
#	define LUA_OPEQ	0
#	define LUA_OPLT	1
#	define LUA_OPLE	2
#endif

/* Event codes */
#define LUA_GCSTOP			0
#define LUA_GCRESTART		1
#define LUA_GCCOLLECT		2
#define LUA_GCCOUNT			3
#define LUA_GCCOUNTB		4
#define LUA_GCSTEP			5
#define LUA_GCSETPAUSE		6
#define LUA_GCSETSTEPMUL	7
#if NV_LUA_VERSION == NV_LUA_52
#	define LUA_GCSETMAJORINC	8
#	define LUA_GCISRUNNING		9
#	define LUA_GCGEN			10
#	define LUA_GCINC			11
#endif

/* Debug event codes */
#define LUA_HOOKCALL	0
#define LUA_HOOKRET	1
#define LUA_HOOKLINE	2
#define LUA_HOOKCOUNT	3
#if NV_LUA_VERSION == NV_LUA_52
#	define LUA_HOOKTAILCALL 4
#elif NV_LUA_VERSION == NV_LUA_51
#	define LUA_HOOKTAILRET 4
#else
#endif

/* Debug event masks */
#define LUA_MASKCALL	(1 << LUA_HOOKCALL)
#define LUA_MASKRET	(1 << LUA_HOOKRET)
#define LUA_MASKLINE	(1 << LUA_HOOKLINE)
#define LUA_MASKCOUNT	(1 << LUA_HOOKCOUNT)

/* lualib.h defines */
#define LUA_TABLIBNAME	"table"
#define LUA_IOLIBNAME	"io"
#define LUA_OSLIBNAME	"os"
#define LUA_STRLIBNAME	"string"
#define LUA_MATHLIBNAME	"math"
#define LUA_DBLIBNAME	"debug"
#define LUA_LOADLIBNAME	"package"
#if NV_LUA_VERSION == NV_LUA_52
#	define LUA_COLIBNAME	"coroutine"
#	define LUA_BITLIBNAME	"bit32"
#endif

#if defined(NV_LUA_DYNAMIC)
#	define NV_LUA_FUN( rtype, fname, fparams ) NV_LUA_API rtype (*fname) fparams
#else
#	define NV_LUA_FUN( rtype, fname, fparams ) NV_LUA_API rtype fname fparams
#endif

#if NV_LUA_VERSION == NV_LUA_52
#	define NV_LUA_FUN_51( rtype, fname, fparams )
#	define NV_LUA_FUN_52 NV_LUA_FUN
#elif NV_LUA_VERSION == NV_LUA_51
#	define NV_LUA_FUN_51 NV_LUA_FUN
#	define NV_LUA_FUN_52( rtype, fname, fparams ) 
#else
#	define NV_LUA_FUN_51( rtype, fname, fparams )
#	define NV_LUA_FUN_52( rtype, fname, fparams ) 
#endif

#include <nv/lib/detail/lua_functions.inc>

#undef NV_LUA_FUN
#undef NV_LUA_FUN_51
#undef NV_LUA_FUN_52

#if NV_LUA_VERSION == NV_LUA_5C
#	define NV_LUA_COMPAT_FUN( rtype, fname, fparams,u1,u2,u3,u4,u5 ) extern rtype (*fname) fparams
#	include <nv/lib/detail/lua_functions_compat.inc>
#	undef NV_LUA_COMPAT_FUN
extern size_t (*lua_rawlen)        (lua_State *L, int idx);
extern int    (*lua_absindex)      (lua_State *L, int idx);
extern void   (*lua_getglobal)     (lua_State *L, const char *var);
extern void   (*lua_setglobal)     (lua_State *L, const char *var);
extern void   (*luaL_requiref)     (lua_State *L, const char *modname, lua_CFunction openf, int glb);
extern void   (*luaL_setmetatable) (lua_State *L, const char *tname);
extern void*  (*luaL_testudata)    (lua_State *L, int ud, const char *tname);
extern void   (*lua_copy)          (lua_State *L, int fromidx, int toidx);
#	define LUA_OPEQ	0
#	define LUA_OPLT	1
#	define LUA_OPLE	2
extern int    (*lua_compare)       (lua_State *L, int idx1, int idx2, int op);
extern void   (*lua_rawgetp)       (lua_State *L, int idx, const void *p);
extern void   (*lua_rawsetp)       (lua_State *L, int idx, const void *p);
extern void   (*lua_pushglobaltable)(lua_State* L);
extern void   (*luaL_setfuncs)     (lua_State *L, const luaL_Reg *l, int nup);
extern int    (*luaL_getsubtable)  (lua_State *L, int idx, const char *fname);

extern const lua_Number* (*lua_version) (lua_State *L);
extern int LUA_UPVALUEINDEX;
extern int LUA_REGISTRYINDEX;
extern int LUA_VERSION_NUM;
#define lua_upvalueindex(i)    (LUA_UPVALUEINDEX-(i))
#define lua_tounsigned(L,idx) (lua_Unsigned)lua_tointeger(L,idx)
#define lua_pushunsigned(L,u) lua_pushinteger(L,(lua_Integer)u)
#define lua_objlen lua_rawlen
#endif

/* Macros */
#if NV_LUA_VERSION == NV_LUA_52
#	define lua_yield(L,n)		lua_yieldk(L, (n), 0, NULL)
#	define lua_call(L,n,r)		lua_callk(L, (n), (r), 0, NULL)
#	define lua_pcall(L,n,r,f)	lua_pcallk(L, (n), (r), (f), 0, NULL)
#	define lua_tonumber(L,i)	lua_tonumberx(L,i,NULL)
#	define lua_tointeger(L,i)	lua_tointegerx(L,i,NULL)
#	define lua_tounsigned(L,i)	lua_tounsignedx(L,i,NULL)
#endif
#define lua_pop(L,n)		lua_settop(L, -(n)-1)
#define lua_newtable(L)		lua_createtable(L, 0, 0)
#define lua_register(L,n,f) (lua_pushcfunction(L, (f)), lua_setglobal(L, (n)))
#define lua_pushcfunction(L,f)	lua_pushcclosure(L, (f), 0)
#define lua_isfunction(L,n)	(lua_type(L, (n)) == LUA_TFUNCTION)
#define lua_istable(L,n)	(lua_type(L, (n)) == LUA_TTABLE)
#define lua_islightuserdata(L,n)	(lua_type(L, (n)) == LUA_TLIGHTUSERDATA)
#define lua_isnil(L,n)		(lua_type(L, (n)) == LUA_TNIL)
#define lua_isboolean(L,n)	(lua_type(L, (n)) == LUA_TBOOLEAN)
#define lua_isthread(L,n)	(lua_type(L, (n)) == LUA_TTHREAD)
#define lua_isnone(L,n)		(lua_type(L, (n)) == LUA_TNONE)
#define lua_isnoneornil(L, n)	(lua_type(L, (n)) <= 0)
#define lua_pushliteral(L, s)	lua_pushlstring(L, "" s, (sizeof(s)/sizeof(char))-1)
#if NV_LUA_VERSION == NV_LUA_52
#	define lua_pushglobaltable(L)  lua_rawgeti(L, LUA_REGISTRYINDEX, LUA_RIDX_GLOBALS)
#elif NV_LUA_VERSION == NV_LUA_51
#	define lua_setglobal(L,s)     lua_setfield(L, LUA_GLOBALSINDEX, (s))
#	define lua_getglobal(L,s)     lua_getfield(L, LUA_GLOBALSINDEX, (s))
#else
#endif

#define lua_tostring(L,i)	lua_tolstring(L, (i), NULL)

/* Aux lib macros */
#if NV_LUA_VERSION == NV_LUA_52
#	define luaL_checkversion(L)	luaL_checkversion_(L, LUA_VERSION_NUM)
#	define luaL_loadfile(L,f)	luaL_loadfilex(L,f,NULL)
#	define luaL_loadbuffer(L,s,sz,n)	luaL_loadbufferx(L,s,sz,n,NULL)
#	define luaL_newlibtable(L,l)	lua_createtable(L, 0, sizeof(l)/sizeof((l)[0]) - 1)
#	define luaL_newlib(L,l)	(luaL_newlibtable(L,l), luaL_setfuncs(L,l,0))
#endif
#define luaL_argcheck(L, cond,numarg,extramsg)	((void)((cond) || luaL_argerror(L, (numarg), (extramsg))))
#define luaL_checkstring(L,n)	(luaL_checklstring(L, (n), NULL))
#define luaL_optstring(L,n,d)	(luaL_optlstring(L, (n), (d), NULL))
#define luaL_checkint(L,n)	((int)luaL_checkinteger(L, (n)))
#define luaL_optint(L,n,d)	((int)luaL_optinteger(L, (n), (d)))
#define luaL_checklong(L,n)	((long)luaL_checkinteger(L, (n)))
#define luaL_optlong(L,n,d)	((long)luaL_optinteger(L, (n), (d)))
#define luaL_typename(L,i)	lua_typename(L, lua_type(L,(i)))
#define luaL_dofile(L, fn) (luaL_loadfile(L, fn) || lua_pcall(L, 0, LUA_MULTRET, 0))
#define luaL_dostring(L, s) (luaL_loadstring(L, s) || lua_pcall(L, 0, LUA_MULTRET, 0))
#define luaL_getmetatable(L,n)	(lua_getfield(L, LUA_REGISTRYINDEX, (n)))
#define luaL_opt(L,f,n,d)	(lua_isnoneornil(L,(n)) ? (d) : f(L,(n)))
#if NV_LUA_VERSION == NV_LUA_52
#	define luaL_prepbuffer(B)	luaL_prepbuffsize(B, LUAL_BUFFERSIZE)
#	define luaL_addchar(B,c) ((void)((B)->n < (B)->size || luaL_prepbuffsize((B), 1)), ((B)->b[(B)->n++] = (c)))
#	define luaL_addsize(B,s)	((B)->n += (s))
#elif NV_LUA_VERSION == NV_LUA_51
#	define luaL_addchar(B,c) ((void)((B)->p < ((B)->buffer+LUAL_BUFFERSIZE) || luaL_prepbuffer(B)), (*(B)->p++ = (char)(c)))
#	define luaL_addsize(B,n)  ((B)->p += (n))
#else
#endif
}

namespace nv {
/* Dynamic load support */
#	if defined( NV_LUA_DYNAMIC )
		bool load_lua_library( const char* path = NV_LUA_PATH );
#	else
		inline bool load_lua_library( const char* path = "" ) { return true; }
#	endif
}

#endif // NV_LIB_LUA_HH
