// Copyright (C) 2014-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

/**
 * @file animated_mesh.hh
 * @author Kornel Kisielewicz
 * @brief animated_mesh
 */

#ifndef NV_INTERFACE_ANIMATED_MESH_HH
#define NV_INTERFACE_ANIMATED_MESH_HH

#include <nv/common.hh>
#include <nv/stl/math.hh>
#include <nv/core/transform.hh>
#include <nv/interface/context.hh>

namespace nv
{

	class animation_entry
	{
	public:
		animation_entry( const std::string& name, bool looping, uint32 frame_rate, float a_start, float a_end ) : m_name( name ), m_looping( looping ), m_frame_rate( frame_rate ),
		m_start( a_start ), m_end( a_end ), m_duration( m_end - m_start ), m_material_idx(0) {}
		const std::string& get_name() const { return m_name; }
		uint32 get_frame_rate() const { return m_frame_rate; }
		float get_duration() const { return m_duration; }
		float get_start() const { return m_start; }
		float get_end() const  { return m_end; }
		bool is_looping() const { return m_looping; }
		void set_range( float a_start, float a_end )
		{
			m_start = a_start;
			m_end   = a_end;
			m_duration = m_end - m_start;
		}
		void set_frame_rate( uint32 rate )
		{
			m_frame_rate = rate;
		}
		void set_material_idx( uint32 idx ) { m_material_idx = idx; }
		uint32 get_material_idx() const { return m_material_idx; }
		virtual ~animation_entry() {}
	protected:
		std::string m_name;
		bool   m_looping;
		uint32 m_frame_rate;
		float  m_start;
		float  m_end;
		float  m_duration;
		uint32 m_material_idx;
	};

	class animated_mesh : public mesh_interface
	{
	public:
		animated_mesh() {}
		virtual void update_animation( animation_entry*, uint32 ) {}
		virtual void run_animation( animation_entry* ) {}
		virtual transform get_node_transform( uint32 ) const { return transform(); }
		virtual mat4 get_node_matrix( uint32 ) const { return mat4(); }
	};


}

#endif // NV_INTERFACE_ANIMATED_MESH_HH
