// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of Nova libraries. 
// For conditions of distribution and use, see copying.txt file in root folder.

#define NV_BASE_COMMON_HH
#define NV_INTERNAL_INCLUDE
#include "nv/stl/assert.hh"
#undef NV_BASE_COMMON_HH

#if NV_COMPILER == NV_MSVC

#	if NV_DEBUG

extern "C" {
	void __cdecl _wassert( const wchar_t * _Message, const wchar_t *_File, unsigned _Line );
}

void nv_internal_assert( const wchar_t * message, const wchar_t* file, unsigned line )
{
	_wassert( message, file, line );
}
#	else  
	void nv_internal_assert( const wchar_t *, const wchar_t*, unsigned ) {}
#	endif  // NV_DEBUG
#else // NV_COMPILER

#	if NV_DEBUG
#	if NV_COMPILER == NV_CLANG
extern "C" {
	extern void __assert(const char *, const char *, unsigned int, const char *)
		throw() __attribute__ ((__noreturn__));
}
#	else
extern "C" {
	extern void __assert_fail(const char *, const char *, unsigned int, const char *)
		throw() __attribute__ ((__noreturn__));
}
#	endif
void nv_internal_assert( const char * assertion, const char * file, unsigned int line, const char * function )
{
#	if NV_COMPILER == NV_CLANG
	__assert(assertion, file, line, function );
#	else
	__assert_fail(assertion, file, line, function );
#	endif
}
#	else
void nv_internal_assert( const char * , const char * , unsigned int , const char * )
{
}
#	endif

#endif // NV_COMPILER

