// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file make_pair.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief STL make_pair library
*/

#ifndef NV_STL_UTILITY_MAKE_PAIR_HH
#define NV_STL_UTILITY_MAKE_PAIR_HH

#include <nv/stl/utility/pair.hh>
#include <nv/stl/type_traits/transforms.hh> // nv::decay
#include <nv/stl/functional/reference.hh> // nv::unwrap_reference

namespace nv
{
	template< typename T >
	struct decay_and_unwrap
	{
		typedef typename decay<T>::type decayed_type;
		typedef typename unwrap_reference<decayed_type>::type type;
		static constexpr bool is_wrapped = unwrap_reference<decayed_type>::is_wrapped;
	};

	template< typename T1, typename T2 > 
	constexpr pair<
		typename decay_and_unwrap< T1 >::type,
		typename decay_and_unwrap< T2 >::type
	>
	make_pair( T1&& first, T2&& second )
	{
		return pair< 
			typename decay_and_unwrap< T1 >::type,
			typename decay_and_unwrap< T2 >::type
		>( nv::forward< T1 >( first ), nv::forward< T2 >( second ) );
	}

}

#endif // NV_STL_UTILITY_MAKE_PAIR_HH
