// Copyright (C) 2012-2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file type_traits.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief type traits
 */
// TODO : "......" function match version?
// TODO : the following symbols are unimplemented:
//  * is_constructible, is_trivially_constructible, is_nothrow_constructible
//  * is_default_constructible, is_trivially_default_constructible, is_nothrow_default_constructible
//  * is_copy_constructible, is_trivially_copy_constructible, is_copy_default_constructible
//  * is_move_constructible, is_trivially_move_constructible, is_move_default_constructible
//  * is_trivially_assignable, is_nothrow_assignable
//  * is_trivially_copy_assignable, is_nothrow_copy_assignable
//  * is_trivially_move_assignable, is_nothrow_move_assignable
//  * is_destructible, is_trivially_destructible, is_nothrow_destructible

#ifndef NV_STL_TYPE_TRAITS_HH
#define NV_STL_TYPE_TRAITS_HH

#include <nv/core/common.hh>
#include <nv/stl/type_traits/common.hh>
#include <nv/stl/type_traits/primary.hh>
#include <nv/stl/type_traits/properties.hh>
#include <nv/stl/type_traits/alignment.hh>
#include <nv/stl/type_traits/transforms.hh>
#include <nv/stl/type_traits/function.hh>

#endif // NV_STL_TYPE_TRAITS_HH
