// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file reference.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief reference_wrapper class and ref/cref
*/

#ifndef NV_STL_FUNCTIONAL_MEM_FN_HH
#define NV_STL_FUNCTIONAL_MEM_FN_HH

#include <nv/stl/functional/common.hh>
#include <nv/stl/functional/invoke.hh>
#include <nv/stl/type_traits/primary.hh>

namespace nv
{

	namespace detail
	{
		template< typename MFP >
		class mem_fn_impl
		{
		public:
			explicit mem_fn_impl( MFP mfp ) noexcept : m_mfp( mfp ) {}

			template < typename... Args >
			typename result_of<MFP&( Args&&... )>::type
				operator()( Args&&... args ) const
			{
				return invoke( m_mfp, forward<Args>( args )... );
			}

		private:
			MFP m_mfp;
		};
	}

	template< typename MFP > 
	inline enable_if_t< is_member_pointer<MFP>::value, detail::mem_fn_impl<MFP> > 
		mem_fn( MFP mfp ) noexcept
	{
		return detail::mem_fn_impl<MFP>( mfp );
	}

}

#endif // NV_STL_FUNCTIONAL_MEM_FN_HH
