// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file function.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief function class
*/

#ifndef NV_STL_FUNCTIONAL_INVOKE_HH
#define NV_STL_FUNCTIONAL_INVOKE_HH

#include <nv/stl/functional/common.hh>
#include <nv/stl/type_traits/common.hh>

namespace nv
{
	namespace detail
	{
		template < typename F, typename... Args >
		inline auto invoke_impl( F&& f, Args&&... args ) ->
			decltype( forward<F>( f )( forward<Args>( args )... ) )
		{
			return forward<F>( f )( forward<Args>( args )... );
		}

		template < typename Base, typename T, typename Derived>
		inline auto invoke_impl( T Base::*pmd, Derived&& ref ) ->
			decltype( forward<Derived>( ref ).*pmd )
		{
			return forward<Derived>( ref ).*pmd;
		}

		template < typename PMD, typename Pointer>
		inline auto invoke_impl( PMD pmd, Pointer&& ptr ) ->
			decltype( ( *forward<Pointer>( ptr ) ).*pmd )
		{
			return ( *forward<Pointer>( ptr ) ).*pmd;
		}

		template < typename Base, typename T, typename Derived, typename... Args>
		inline auto invoke_impl( T Base::* pmf, Derived&& ref, Args&&... args ) ->
			decltype( ( forward<Derived>( ref ).*pmf )( forward<Args>( args )... ) )
		{
			return ( forward<Derived>( ref ).*pmf )( forward<Args>( args )... );
		}

		template < typename PMF, typename Pointer, typename... Args>
		inline auto invoke_impl( PMF pmf, Pointer&& ptr, Args&&... args ) ->
			decltype( ( ( *forward<Pointer>( ptr ) ).*pmf )( forward<Args>( args )... ) )
		{
			return ( ( *forward<Pointer>( ptr ) ).*pmf )( forward<Args>( args )... );
		}

	}

	template< typename F, typename... Args >
	inline auto invoke( F&& f, Args&&... args ) ->
		decltype( detail::invoke_impl( forward<F>( f ), forward<Args>( args )... ) )
	{
		return detail::invoke_impl( forward<F>( f ), forward<Args>( args )... );
	}

}

#endif // NV_STL_FUNCTIONAL_INVOKE_HH

