// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file comparisons.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief functional comparisons
*/

#ifndef NV_STL_FUNCTIONAL_COMPARISONS_HH
#define NV_STL_FUNCTIONAL_COMPARISONS_HH

#include <nv/stl/functional/common.hh>

namespace nv
{

	template< typename T = void >
	struct equal_to
	{
		typedef bool result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs == rhs;
		}
	};

	template<>
	struct equal_to< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) == static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) == static_cast<T2&&>( rhs );
		}
	};

	template< typename T = void >
	struct not_equal_to
	{
		typedef bool result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs != rhs;
		}
	};

	template<>
	struct not_equal_to< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) != static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) != static_cast<T2&&>( rhs );
		}
	};

	template< typename T = void >
	struct greater
	{
		typedef bool result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs > rhs;
		}
	};

	template<>
	struct greater< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) > static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) > static_cast<T2&&>( rhs );
		}
	};

	template< typename T = void >
	struct less
	{
		typedef bool result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs < rhs;
		}
	};

	template<>
	struct less< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) < static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) < static_cast<T2&&>( rhs );
		}
	};


	template< typename T = void >
	struct greater_equal
	{
		typedef bool result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs >= rhs;
		}
	};

	template<>
	struct greater_equal< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) >= static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) >= static_cast<T2&&>( rhs );
		}
	};

	template< typename T = void >
	struct less_equal
	{
		typedef bool result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs <= rhs;
		}
	};

	template<>
	struct less_equal< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) <= static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) <= static_cast<T2&&>( rhs );
		}
	};

}

#endif // NV_STL_FUNCTIONAL_COMPARISONS_HH

