// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file bitwise_ops.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief functional bitwise function objects
*/

#ifndef NV_STL_FUNCTIONAL_BITWISE_OPS_HH
#define NV_STL_FUNCTIONAL_BITWISE_OPS_HH

#include <nv/stl/functional/common.hh>

namespace nv
{

	template< typename T = void >
	struct bit_and
	{
		typedef T result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs & rhs;
		}
	};

	template<>
	struct bit_and< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) & static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) & static_cast<T2&&>( rhs );
		}
	};

	template< typename T = void >
	struct bit_or
	{
		typedef T result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs | rhs;
		}
	};

	template<>
	struct bit_or< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) | static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) | static_cast<T2&&>( rhs );
		}
	};

	template< typename T = void >
	struct bit_xor
	{
		typedef T result_type;
		typedef T first_argument_type;
		typedef T second_argument_type;

		constexpr bool operator() ( const T& lhs, const T& rhs ) const
		{
			return lhs ^ rhs;
		}
	};

	template<>
	struct bit_xor< void >
	{
		typedef is_transparent_t is_transparent;

		template < typename T1, typename T2 >
		constexpr auto operator() ( T1&& lhs, T2&& rhs ) const
			-> decltype( static_cast<T1&&>( lhs ) ^ static_cast<T2&&>( rhs ) )
		{
			return static_cast<T1&&>( lhs ) ^ static_cast<T2&&>( rhs );
		}
	};

}

#endif // NV_STL_FUNCTIONAL_BITWISE_OPS_HH
