// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file fixed_container_handler.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief fixed contiguous container handler
*/

#ifndef NV_STL_CONTAINER_FIXED_CONTAINER_HANDLER_HH
#define NV_STL_CONTAINER_FIXED_CONTAINER_HANDLER_HH

#include <nv/core/common.hh>
#include <nv/stl/container/initialize_policy.hh>

namespace nv
{

	template <
		typename Storage,
		typename InitializePolicy = policy_initialize_standard
	>
	class fixed_container_handler : public Storage
	{
	public:
		typedef typename Storage::value_type value_type;
		typedef typename Storage::size_type  size_type;

		fixed_container_handler()
		{
			InitializePolicy::initialize( data(), data() + Storage::capacity() );
		}

		explicit fixed_container_handler( default_init )
		{
			uninitialized_construct( data(), data() + Storage::capacity() );
		}

		explicit fixed_container_handler( const value_type& v )
		{
			uninitialized_fill( data(), data() + Storage::capacity(), v );
		}

		~fixed_container_handler()
		{
			InitializePolicy::destroy( data(), data() + Storage::capacity() );
		}

		// prevent copying 
		fixed_container_handler( const fixed_container_handler& ) = delete;
		fixed_container_handler& operator=( const fixed_container_handler& ) = delete;
		// allow move
		fixed_container_handler( fixed_container_handler&& ) = default;
		fixed_container_handler& operator=( fixed_container_handler&& ) = default;
	};

}

#endif // NV_STL_CONTAINER_FIXED_CONTAINER_HANDLER_HH
