// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LUA_FUNCTION_HH
#define NV_LUA_FUNCTION_HH

#include <nv/core/common.hh>
#include <nv/lua/lua_values.hh>
#include <nv/lua/lua_path.hh>

namespace nv
{
	namespace lua
	{

		class state;

		class function_base
		{
		public:
			function_base( lua_State* a_L, const path& a_path, bool a_global = true );
			function_base( const function_base& func );
			function_base& operator=( const function_base& func );
			~function_base();
		protected:
			void retrieve();
			void call( int args, int results );

		protected:
			int m_ref;
			lua_State* L;
		};

		template < typename R >
		class function : public function_base
		{
		public:
			function( lua_State *a_L, const path& a_path, bool a_global = true )
				: function_base( a_L, a_path, a_global )
			{
			}

			R operator()()
			{
				retrieve();
				return call_result<R>(0);
			}

			template <typename... Args>
			R operator()( Args&&... args )
			{
				retrieve();
				detail::push_values(L, std::forward<Args>(args)...);
				return call_result<R>(sizeof...(Args));
			}

		protected:
			template< typename RR >
			R call_result( int params )
			{
				call( params, 1 );
				R value;
				detail::pop_value( L, value );
				return value;
			}
		};
 
		// I actually wonder whether this hack will work everywhere
 		template<>
 		template<>
 		inline void function<void>::call_result<void>( int params )
 		{
 			call( params, 0 );
 		}

	} // namespace lua

} // namespace nv

#endif // NV_LUA_HH