// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file exception.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief nv exception bases
 */

#ifndef NV_CORE_EXCEPTION_HH
#define NV_CORE_EXCEPTION_HH

#include <nv/core/common.hh>
#include <string>
#include <exception>
#include <stdexcept>

namespace nv
{
	/**
	 * NV logic_error.
	 *
	 * Inherits std::logic_error.
	 */
	class logic_error : public std::logic_error
	{
	public:
		explicit logic_error( const std::string& msg ) : std::logic_error( msg ) {}
	};

	/**
	 * NV runtime_error.
	 *
	 * Inherits std::runtime_error.
	 */
	class runtime_error : public std::runtime_error
	{
	public:
		explicit runtime_error( const std::string& msg ) : std::runtime_error( msg ) {}
	};
}

#endif // NV_CORE_EXCEPTION_HH
