// Copyright (C) 2014 ChaosForge Ltd
// This file is part of Nova Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/sdl/sdl_window_manager.hh"

#include "nv/sdl/sdl_window.hh"
#include "nv/core/logging.hh"
#include "nv/lib/sdl.hh"
#include "nv/lib/sdl_image.hh"
#include "nv/interface/image_data.hh"

using namespace nv;

sdl::window_manager::window_manager()
{
	nv::load_sdl_library();

	if ( SDL_Init(0) < 0 )
	{
		NV_LOG_CRITICAL( "SDL initialization failed: ", SDL_GetError( ) );
		return; // TODO: Error report
	}
}

window* sdl::window_manager::create_window( device* dev, uint16 width, uint16 height, bool fullscreen )
{
	if ( ! SDL_WasInit( SDL_INIT_VIDEO ) ) SDL_InitSubSystem( SDL_INIT_VIDEO );
	return new sdl::window( dev, width, height, fullscreen );
}

void* sdl::window_manager::adopt_window( void* sys_w_handle )
{
	if ( ! SDL_WasInit( SDL_INIT_VIDEO ) ) SDL_InitSubSystem( SDL_INIT_VIDEO );
	return SDL_CreateWindowFrom( sys_w_handle );
}

void nv::sdl::window_manager::sleep( uint32 ms )
{
	SDL_Delay( ms );
}

nv::uint32 nv::sdl::window_manager::get_ticks()
{
	return SDL_GetTicks();
}

nv::sdl::window_manager::~window_manager()
{
	SDL_Quit();
}

