// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

// WARNING: this file is explicitly designed to fuck with your brain

#ifndef NV_ANIMATION_KEY_HH
#define NV_ANIMATION_KEY_HH

#include <nv/core/common.hh>
#include <nv/core/transform.hh>
#include <nv/stl/math.hh>

namespace nv
{

	enum class animation_slot : uint8
	{
		TIME     = 0,
		POSITION = 1,
		ROTATION = 2,
		SCALE    = 3,
		TFORM    = 4,

		SLOT_MAX       = 4,
		SLOT_MAX_STORE = 8,
	};

	namespace detail
	{
		template < typename KEY, animation_slot SLOT >
		struct key_has_slot_impl
		{
			static bool const value = false;
		};

		template < typename KEY >
		struct key_has_slot_impl< KEY, animation_slot::TIME >
		{
		private:
			struct fallback { int time; };
			struct derived : KEY, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::time>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename KEY >
		struct key_has_slot_impl< KEY, animation_slot::POSITION >
		{
		private:
			struct fallback { int position; };
			struct derived : KEY, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::position>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename KEY >
		struct key_has_slot_impl< KEY, animation_slot::ROTATION >
		{
		private:
			struct fallback { int rotation; };
			struct derived : KEY, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::rotation>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename KEY >
		struct key_has_slot_impl< KEY, animation_slot::SCALE >
		{
		private:
			struct fallback { int scale; };
			struct derived : KEY, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::scale>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename KEY >
		struct key_has_slot_impl< KEY, animation_slot::TFORM >
		{
		private:
			struct fallback { int tform; };
			struct derived : KEY, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::tform>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename KEY, animation_slot SLOT, bool HAS_SLOT >
		struct key_slot_info_impl
		{
		};

		template < typename KEY, animation_slot SLOT >
		struct key_slot_info_impl < KEY, SLOT, false >
		{
			typedef empty_type value_type;
			static const datatype etype  = datatype::NONE;
			static const int      offset = 0;
		};

		template < typename KEY >
		struct key_slot_info_impl< KEY, animation_slot::TIME, true >
		{
			typedef decltype( KEY::time ) value_type;
			static const datatype etype  = type_to_enum< decltype( KEY::time ) >::type;
			static const int      offset = NV_OFFSET_OF( KEY, time );
		};

		template < typename KEY >
		struct key_slot_info_impl< KEY, animation_slot::POSITION, true >
		{
			typedef decltype( KEY::position ) value_type;
			static const datatype etype  = type_to_enum< decltype( KEY::position ) >::type;
			static const int      offset = NV_OFFSET_OF( KEY, position );
			static void interpolate( KEY& key, const KEY& k1, const KEY& k2, float factor )
			{
				key.position = nv::interpolate( k1.position, k2.position, factor );
			}
		};

		template < typename KEY >
		struct key_slot_info_impl< KEY, animation_slot::ROTATION, true >
		{
			typedef decltype( KEY::rotation ) value_type;
			static const datatype etype  = type_to_enum< decltype( KEY::rotation ) >::type;
			static const int      offset = NV_OFFSET_OF( KEY, rotation );
			static void interpolate( KEY& key, const KEY& k1, const KEY& k2, float factor )
			{
				key.rotation = nv::interpolate( k1.rotation, k2.rotation, factor );
			}
		};

		template < typename KEY >
		struct key_slot_info_impl< KEY, animation_slot::SCALE, true >
		{
			typedef decltype( KEY::scale ) value_type;
			static const datatype etype  = type_to_enum< decltype( KEY::scale ) >::type;
			static const int      offset = NV_OFFSET_OF( KEY, scale );
			static void interpolate( KEY& key, const KEY& k1, const KEY& k2, float factor )
			{
				key.scale = nv::interpolate( k1.scale, k2.scale, factor );
			}
		};

		template < typename KEY >
		struct key_slot_info_impl< KEY, animation_slot::TFORM, true >
		{
			typedef decltype( KEY::tform ) value_type;
			static const datatype etype  = type_to_enum< decltype( KEY::tform ) >::type;
			static const int      offset = NV_OFFSET_OF( KEY, tform );
			static void interpolate( KEY& key, const KEY& k1, const KEY& k2, float factor )
			{
				key.tform = nv::interpolate( k1.tform, k2.tform, factor );
			}
		};
	}

	template < typename KEY, animation_slot SLOT >
	struct key_has_slot : bool_constant< detail::key_has_slot_impl< KEY, SLOT >::value >
	{
	};


	template < typename KEY, animation_slot SLOT >
	struct key_slot_info : public detail::key_slot_info_impl< KEY, SLOT, detail::key_has_slot_impl< KEY, SLOT >::value >
	{
	};

	struct key_descriptor_slot
	{
		datatype       etype;
		uint32         offset;
		animation_slot vslot;
		key_descriptor_slot() : etype(NONE), offset(0), vslot(animation_slot::TIME) {}
	};

	struct key_descriptor
	{
		key_descriptor_slot slots[ (uint16)animation_slot::SLOT_MAX_STORE ];
		uint32              count;
		uint32              size;

		key_descriptor() : count(0), size(0) {}

		template < typename KEY >
		void initialize()
		{
			count = 0;
			initialize_slot< KEY, animation_slot::TIME >();
			initialize_slot< KEY, animation_slot::POSITION >();
			initialize_slot< KEY, animation_slot::ROTATION >();
			initialize_slot< KEY, animation_slot::SCALE >();
			initialize_slot< KEY, animation_slot::TFORM >();
			size = sizeof( KEY );
		}

		bool operator==( const key_descriptor& rhs ) const
		{
			if ( size  != rhs.size )  return false;
			if ( count != rhs.count ) return false;
			for ( uint32 i = 0; i < count; ++i )
			{
				if ( slots[i].etype  != rhs.slots[i].etype )  return false;
				if ( slots[i].offset != rhs.slots[i].offset ) return false;
				if ( slots[i].vslot  != rhs.slots[i].vslot )  return false;
			}
			return true;
		}

	private:
		template < typename KEY, animation_slot SLOT >
		void initialize_slot()
		{
			typedef key_slot_info< KEY, SLOT > slot_info;
			slots[ count ].etype  = slot_info::etype;
			if ( slots[ count ].etype != datatype::NONE )
			{
				slots[ count ].vslot  = SLOT;
				slots[ count ].offset = slot_info::offset;
				count++;
			}
		}
	};

}

#endif // NV_ANIMATION_KEY_HH
