// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
* @file type_info.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief type info
*/
// TODO: remove typeinfo?

#ifndef NV_STL_TYPE_INFO_HH
#define NV_STL_TYPE_INFO_HH

#include <nv/core/common.hh>
#include <typeinfo>

namespace nv
{

	class type_index
	{
	public:
		inline type_index( const std::type_info& info ) : m_type_info( &info ) {}
		inline size_t hash_code() const { return m_type_info->hash_code(); }
		inline const char *name() const { return m_type_info->name(); }

		inline bool operator==( const type_index& rhs ) const
		{
			return ( *m_type_info == *rhs.m_type_info );
		}

		inline bool operator!=( const type_index& rhs ) const
		{
			return ( !( *this == rhs ) );
		}

		inline bool operator<( const type_index& rhs ) const
		{
			return ( m_type_info->before( *rhs.m_type_info ) );
		}

		inline bool operator>=( const type_index& rhs ) const
		{
			return ( !( *this < rhs ) );
		}

		inline bool operator>( const type_index& rhs ) const
		{
			return ( rhs < *this );
		}

		inline bool operator<=( const type_index& rhs ) const
		{
			return ( !( rhs < *this ) );
		}

	private:
		const std::type_info* m_type_info;
	};

}

#endif // NV_STL_TYPE_INFO_HH
