// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
* @file function.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief type traits - function traits
*/
// TODO: remove_cv? call traits? support "......"?

#ifndef NV_STL_TRAITS_FUNCTION_HH
#define NV_STL_TRAITS_FUNCTION_HH

#include <nv/core/common.hh>
#include <nv/stl/traits/common.hh>

namespace nv
{

	namespace detail
	{

		template < typename F >
		struct function_traits_impl
		{

		};

		template < typename R >
		struct function_traits_impl < R( *)( void ) >
		{
			typedef R( *type )( );
			typedef R        return_type;
			typedef void     class_type;
			static const int arg_count = 0;
		};

		template < typename R, typename... Args >
		struct function_traits_impl < R( *)( Args... ) >
		{
			typedef R( *type )( Args... );
			typedef R        return_type;
			typedef void     class_type;
			static const int arg_count = sizeof...( Args );
		};

		template < class C, typename R >
		struct function_traits_impl < R( C::* )( ) >
		{
			typedef R( *type )( );
			typedef R       return_type;
			typedef C       class_type;
			static const int arg_count = 0;
		};

		template < class C, typename R, typename... Args >
		struct function_traits_impl < R( C::* )( Args... ) >
		{
			typedef R( C::*type )( Args... );
			typedef R        return_type;
			typedef C        class_type;
			static const int arg_count = sizeof...( Args );
		};

	}

	template < typename F >
	struct function_traits : detail::function_traits_impl < F >
	{

	};

	template < typename T >
	struct return_type
	{
		typedef typename function_traits< T >::return_type type;
	};
	template < typename T >
	using return_type_t = typename return_type<T>::type;

	template < typename T >
	struct memfn_class_type
	{
		typedef typename function_traits< T >::class_type type;
	};
	template < typename T >
	using memfn_class_type_t = typename memfn_class_type<T>::type;

}

#endif // NV_STL_TRAITS_FUNCTION_HH
