// Copyright (C) 2015 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
* @file utility.hh
* @author Kornel Kisielewicz epyon@chaosforge.org
* @brief STL utility library
*/

#ifndef NV_STL_UTILITY_HH
#define NV_STL_UTILITY_HH

#include <nv/core/common.hh>
#include <nv/stl/type_traits.hh>

namespace nv
{

	template< typename T >
	inline typename remove_reference<T>::type&& move( T&& arg ) NV_NOEXCEPT
	{
		return ( ( typename remove_reference<T>::type&& )arg );
	}

	template < typename T >
	inline T&& forward( typename remove_reference<T>::type& t ) NV_NOEXCEPT
	{
		return static_cast<T&&>( t );
	}

	template < typename T >
	inline T&& forward( typename remove_reference<T>::type&& t ) NV_NOEXCEPT
	{
		static_assert( !is_lvalue_reference<T>::value, "Can not forward an rvalue as an lvalue." );
		return static_cast<T&&>( t );
	}

	// TODO: change to swap once you get rid of STL
	template< typename T >
	void swap( T& x, T& y )
	{
		T t = move( x );
		x = move( y );
		y = move( t );
	}

	template < typename T >
	inline const T&	max( const T& a, const T& b )
	{
		return a < b ? b : a;
	}

	template < typename T >
	inline const T&	min( const T& a, const T& b )
	{
		return a > b ? b : a;
	}

}

#endif // NV_STL_UTILITY_HH
