// Copyright (C) 2014 ChaosForge Ltd 
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include <nv/wx/wx_canvas.hh>

wxBEGIN_EVENT_TABLE( nv::wx_gl_canvas, wxWindow )
EVT_PAINT( nv::wx_gl_canvas::on_paint )
wxEND_EVENT_TABLE()

nv::wx_gl_canvas::wx_gl_canvas( wxWindow *parent )
	: wxWindow( parent, wxID_ANY, wxDefaultPosition, wxDefaultSize,
	wxFULL_REPAINT_ON_RESIZE )
{
	nv::load_gl_no_context();
	wxClientDC dc( this );
	m_render = true;
	m_wm = new nv::sdl::window_manager;
	m_device = new nv::gl_device();
	m_window = new nv::gl_window( m_device, m_wm, new nv::sdl::input(), GetHWND(), dc.GetHDC() );
	m_context = m_window->get_context();
}

nv::wx_gl_canvas::~wx_gl_canvas()
{
	delete m_window;
	delete m_device;
}

void nv::wx_gl_canvas::on_paint( wxPaintEvent& )
{
	const wxSize client_size = GetClientSize();
	m_context->set_viewport( nv::ivec4( nv::ivec2(), client_size.x, client_size.y ) );
	on_update();
}

void nv::wx_gl_canvas::stop()
{
	Disconnect( wxEVT_IDLE, wxIdleEventHandler( wx_gl_canvas::on_idle ) );
	//m_update_timer->Stop();
}

void nv::wx_gl_canvas::start()
{
	Connect( wxID_ANY, wxEVT_IDLE, wxIdleEventHandler( wx_gl_canvas::on_idle ) );
	//m_update_timer->Start(20);
}

void nv::wx_gl_canvas::on_idle( wxIdleEvent& evt )
{
	if ( m_render )
	{
		on_update();
		evt.RequestMore(); // render continuously, not only once on idle
	}
}

nv::wx_log_text_ctrl_sink::wx_log_text_ctrl_sink( wxTextCtrl* a_text_ctrl ) : m_text_ctrl( a_text_ctrl )
{

}

void nv::wx_log_text_ctrl_sink::log( nv::log_level level, const std::string& message )
{
	wxString str;
	str << timestamp() << " [" << padded_level_name( level ) << "] " << message << "\n";
	m_text_ctrl->AppendText( str );
}

nv::wx_app_base::wx_app_base()
{
	static nv::logger log( nv::LOG_TRACE );
	log.add_sink( new nv::log_file_sink( "log.txt" ), nv::LOG_TRACE );
	NV_LOG( nv::LOG_NOTICE, "Logging started" );
}

bool nv::wx_app_base::OnInit()
{
	if ( !wxApp::OnInit() )
		return false;

	return initialize();
}

int nv::wx_app_base::OnExit()
{
	NV_LOG( nv::LOG_NOTICE, "Logging stopped" );
	return wxApp::OnExit();
}
