// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
//
// TODO : prepare tests:
//  * correctness tests
//  * compatibility tests
//  * performance tests
// TODO : resolve should not take a lua_State

#ifndef NV_LUA_PATH_HH
#define NV_LUA_PATH_HH

#include <nv/core/common.hh>
#include <nv/stl/string.hh>
#include <cstring>

struct lua_State;

namespace nv
{
	namespace lua
	{

		class path
		{
		public:
			template < typename... Args >
			path( Args&&... args ) : m_count(0)
			{
				static_assert( sizeof...( Args ) < 8, "Path can only take up to 8 arguments!" );
				initialize( std::forward<Args>( args )... );
			}

			std::string to_string() const;
			bool resolve( lua_State* L, bool global = true ) const;
		
		private:
			template < typename T >
			void initialize( T&& arg ) 
			{
				push( std::forward<T>( arg ) );
				if ( m_count == 1 && m_elements[0].length ) parse();
			}

			template < typename T, typename... Args >
			void initialize( T&& arg, Args&&... args )
			{ 
				push( std::forward<T>( arg ) );
				initialize( std::forward<Args>( args )... );
			}

			void parse();
			void push( size_t value );
			void push( string_ref p );

		private:
			struct element
			{
				union
				{
					size_t      value;
					const char* str;
				};
				size_t      length;
			};

			element m_elements[8];
			sint32  m_count;
		};

	} // namespace lua

} // namespace nv

#endif // NV_LUA_PATH_HH
