// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LIB_FMOD_HH
#define NV_LIB_FMOD_HH

#include <nv/core/common.hh>

#define NV_FMOD_DYNAMIC
//#define NV_FMOD_SHARED

#if NV_PLATFORM == NV_WINDOWS
#	define NV_FMOD_PATH "fmodex.dll"
#elif NV_PLATFORM == NV_APPLE
#	define NV_FMOD_PATH "fmodex.framework/fmodex"
#else
#	define NV_FMOD_PATH "libfmodex.so"
#endif

extern "C" {

#if NV_PLATFORM == NV_WINDOWS 
#	define NV_FMOD_APIENTRY __stdcall
#else
#	define NV_FMOD_APIENTRY
#endif

#if defined(NV_FMOD_SHARED) && (NV_PLATFORM == NV_WINDOWS)
#	define NV_FMOD_API __declspec(dllimport)
#else
#	define NV_FMOD_API extern
#endif

#include <nv/lib/detail/fmod_types.inc>

#if defined(NV_FMOD_DYNAMIC)
#	define NV_FMOD_FUN( rtype, fname, fparams ) NV_FMOD_API rtype ( NV_FMOD_APIENTRY *fname) fparams
#else
#	define NV_FMOD_FUN( rtype, fname, fparams ) NV_FMOD_API rtype NV_FMOD_APIENTRY fname fparams
#endif

#include <nv/lib/detail/fmod_functions.inc>

#undef NV_FMOD_FUN
}

const char *FMOD_ErrorString(FMOD_RESULT errcode);

namespace nv {
	/* Dynamic load support */
#	if defined( NV_FMOD_DYNAMIC )
	bool load_fmod_library( const char* path = NV_FMOD_PATH );
#	else
	inline bool load_fmod_library( const char* path = "" ) { return true; }
#	endif
}

#endif // NV_LIB_FREETYPE_HH
